Public Class AResponse
    Public ResponseTime As Double
    Public KeyCode As Integer
End Class

Public Class ExpTrial
    Public ParamNames As New Collection
    Public ParamValues As New Collection
    Public ParentTrialList As ExpTrialList
    Public Responses As New Collection

    Sub New(ByVal aTrialList)
        ParentTrialList = aTrialList
    End Sub

    Overridable Sub Run()
    End Sub

    Overridable Sub AddParameter(ByVal ParamName As String, ByVal ParamValue As String)
        ParamNames.Add(ParamName)
        ParamValues.Add(ParamValue, ParamName)
    End Sub

    Overridable Sub DumpParamsToFile()
        For Each ParamName As String In ParamNames
            System.IO.File.AppendAllText(ParentTrialList.OutputFilename, ParamValues(ParamName) & vbTab)
        Next
        Dim ind As Integer = 0
        For Each myresp As AResponse In Responses
            If (ind = ParentTrialList.MaxNumberOfResponses) Then
                Exit For
            End If
            System.IO.File.AppendAllText(ParentTrialList.OutputFilename, myresp.KeyCode & vbTab)
            System.IO.File.AppendAllText(ParentTrialList.OutputFilename, myresp.ResponseTime - ParamValues("TrialStartTime") & vbTab)
            ind = ind + 1
        Next
        For i As Integer = ind To ParentTrialList.MaxNumberOfResponses - 1
            System.IO.File.AppendAllText(ParentTrialList.OutputFilename, vbTab & vbTab)
        Next
    End Sub

    Overridable Sub DumpParamHeadersToFile()
        For Each ParamName As String In ParamNames
            System.IO.File.AppendAllText(ParentTrialList.OutputFilename, ParamName & vbTab)
        Next
        For i As Integer = 0 To ParentTrialList.MaxNumberOfResponses - 1
            System.IO.File.AppendAllText(ParentTrialList.OutputFilename, "KeyCode" & i & vbTab)
            System.IO.File.AppendAllText(ParentTrialList.OutputFilename, "ResponseTime" & i & vbTab)
        Next
    End Sub
End Class

