function y = my_poly(x, c, w)
% commented text at the beginning shows up for "help my_poly"
% my_poly: output value of a polynomial specified by vectors w and c
% w: weights for each polynomial term
% c: powers of the polynomial terms
% such that y=w(i)*x^c(i)

lc = length(c);

% the next part is not necessary, but may avoid problems
lw = length(w);
if lc ~= lw,
    fprintf(1, 'Vectors do not have the same length\n');
    return
end

y = 0;  % initialise y
for i = 1:lc,  % go through every element of c (and w)
    y = y + w(i)*x^c(i);  % add the value of this polynomial term
end;
    
