function [beta, Xinv] = solve_equation_inv(X, y)
% Solve equation y = X * beta with X invertible.
% Parameters:
%   X: design matrix, dimension nxn and invertible
%   y: data vector, dimension n
%   beta: parameter vector, dimension n
% Returns:
%   beta: parameter vector, dimension n
%   Xinv: inverse matrix of X, dimension nxn
    
    % compute inverse of design matrix
    Xinv = inv(X);
    
    % Computing beta
    beta = Xinv * y;
    
end