function [data, y1, y2] = simulate_data(beta, freqs, latencies, noise)
% Create data adding two sine curves with different amplitudes plus noise.
% Parameters:
%   beta: amplitudes, dimension 2
%   freqs: Frequencies of sine curves, dimension 2
%   latencies: latencies to simulate, dimension n
%   noise: amplitude of noise, scalar
% Returns:
%   data: Simulated data, dimension n

y1 = sin(2 * pi * freqs(1) * latencies)'
y2 = sin(2 * pi * freqs(2) * latencies)'

data = beta(1) * y1 + beta(2) * y2

% Add Gaussian noise
data = data + noise * randn(length(data), 1)

end