function [beta, Xpinv] = solve_equation(X, y)
% Solve any linear equation y = X * beta for beta using pinv.
% Parameters:
%   X: design matrix, dimension mxn
%   y: data vector, dimension m
% Returns:
%   beta: parameter vector, dimension n
%   Xinv: inverse matrix of X, dimension nxm
    
    % compute pseudoinverse of design matrix
    Xpinv = pinv(X);
    
    % Computing beta
    beta = Xpinv * y;
    
end