% Solve simple scalar equation
x = 3;
y = 9;
beta = solve_scalar_equation(x, y);

% Solve two independent linear equations
X = [3 0; 0 4]; % design matrix
y = [9 16]' % data vector
beta = solve_orth_equation(X, y)

% Solve the same equations, but with "inverse matrix"
[beta, Xinv] = solve_equation_inv(X, y)

% Solve arbitrary equation with invertible square design matrix
X = [3 1; 1 4]; % design matrix
[beta, Xinv] = solve_equation_inv(X, y)

% Solve arbitrary linear equations (over-/under-determined)

y = [1 2 3]'
X = [1 0; 1 1; 1 2]; % overdetermined
[beta, Xpinv] = solve_equation(X, y)

y = [1 2]'
X = [3 0 0; 0 4 0]; % underdetermined
[beta, Xpinv] = solve_equation(X, y)


% Simulate data with sine waves
lats = [0:0.01:1]
[data, y1, y2] = simulate_data([1, 1], [2, 3], lats, 0)

plot(lats, data)

% estimate parameters from simulated data
beta = solve_equation([y1, y2], data)

% Compute and plot the predicted data with real data
datapre = [y1, y2] * beta;

hold on

plot(lats, datapre, 'r')

% Add the difference
hold on
datadiff = data - datapre;
plot(lats, datadiff, 'k')


% Exercises

% Run the simulations with increasingly similar frequencies (e.g. [2.,
% 2.001] and compare the real and estimated betas.

% Compute the correlation of the predictor variables (in design matrix). Is
% this related to the observations in the previous exercise?

% Compute the residual variance and correlation between real and predicted
% data. How do they depend on the noise amplitude?
