
% MATLAB SCRIPT OPTIMISATION

clear all
close all


%% PART 2

% REGRESSION and PREDICTION

% PREP DATA

% load dataset
[X,T] = bodyfat_dataset;
X = X'; T= T';

% select features
feature_sel = [1:13]; % 1: age in y, 2: weight in lbs, 3: height in inches
X = X(:,feature_sel);

% split into training, validation and test data
train_idx   = 1:200;
test_idx    = 201:252;
X_train = X(train_idx,:);   % training data set
X_test  = X(test_idx,:);    % test data set
T_train = T(train_idx,1);   % training target set
T_test  = T(test_idx,1);    % test target set


%% Predict T with regression model (pseudo inverse pinv)

% calculate model
LR_model = pinv(X_train)*T_train; % using pinv()
LR_model = inv(X_train'*X_train)*X_train'*T_train; % direct calc

% evaluate model
Y_all  = LR_model'*X';
Y_test = LR_model'*X_test';
Y_all = Y_all'; 
Y_test = Y_test';

% test error
err_test = T_test - Y_test;
mse_test_LR = mean(err_test.^2);
% all data error
err_all = T - Y_all;
mse_all_LR = mean(err_all.^2);

% plot estimated output data Y vs. target data T
figure(3)
hold on

    subplot(2,2,1)
    c = linspace(1,10,size(T_test,1));
    scatter(Y_test,T_test,[],c,'filled'); line(0:50,0:50,'Color','k'); lsline
    xlim([0 50]); ylim([0 50]); xlabel('Estimate'); ylabel('Target');
    title('LR: TEST DATA','FontSize',12)

    subplot(2,2,3)
    c = linspace(1,10,size(T,1));
    scatter(Y_all,T,[],c,'filled'); line(0:50,0:50,'Color','k'); lsline
    xlim([0 50]); ylim([0 50]); xlabel('Estimate'); ylabel('Target');
    title('LR: ALL DATA','FontSize',12)



%% NEURAL NETWORK FOR REGRESSION

% define neural network model

    net = feedforwardnet([15],'traingd'); % gradient descent, check performance
    net.trainParam.lr = 0.0001;

    %net = feedforwardnet([15],'traingdm'); % gradient descent with momentum
    %net.trainParam.lr = 0.001; % try 0.001, 0.01, 0.1
    
    %net = feedforwardnet([15],'traingda'); % gradient descent with adaptive learning rate
    %net.trainParam.lr = 0.001;
    
    %net = feedforwardnet([15],'trainrp'); % resilient backpropagation

% adjust parameters of training procedure
    
    net.divideFcn = 'dividetrain';          % use all data for training
   
%     net.divideFcn = 'dividerand';          % random data for train,test,valid
%     net.divideParam.trainRatio  = 70/100;  % train set 
%     net.divideParam.valRatio    = 15/100;  % validation set
%     net.divideParam.testRatio   = 15/100;  % test set
    
    net.trainParam.epochs   = 1000;         % number of epochs
    net.trainParam.time     = 60;           % Max time of training (in s)
    net.trainParam.min_grad = 1e-10;        % min grad to stop learning
    net.trainParam.max_fail = 5000;         % max validation checks
    net.trainParam.showCommandline = 1;     % show command window output
    net.trainParam.show = 100;              % update rate (every N epochs)
    
% loss function
reg = 0;
if reg==0
    net.performFcn = 'mse';
else
    net.performFcn = 'msereg';   % MSE with l2 regularization
    net.performParam.regularization = reg; 
end
    
                
% train neural network model
X_train = X_train';
T_train = T_train';

[net,trainlog] = train(net,X_train,T_train);

% evaluate neural network model
E_test = net(X_test');
E_all = net(X');

% test error
err_test = T_test - E_test';
mse_test_NN = mean(err_test.^2);
% all data error
err_all = T - E_all';
mse_all_NN = mean(err_all.^2);

figure(3)

    subplot(2,2,2)
    c = linspace(1,10,size(T_test,1));
    scatter(E_test,T_test,[],c,'filled'); line(0:50,0:50,'Color','k'); lsline
    xlim([0 50]); ylim([0 50]); xlabel('Estimate'); ylabel('Target');
    title('NN: TEST DATA','FontSize',12)

    subplot(2,2,4)
    c = linspace(1,10,size(T,1));
    scatter(E_all,T,[],c,'filled'); line(0:50,0:50,'Color','k'); lsline
    xlim([0 50]); ylim([0 50]); xlabel('Estimate'); ylabel('Target');
    title('NN: ALL DATA','FontSize',12)
