
% MATLAB SCRIPT OPTIMISATION

% PART 1 

clear all
close all

format compact



%% HANDS ON (1): FIND MINIMUM OF FUNCTION

% optimisation tools in Matlab

% 1) activate show optimisation steps by setting options: 
% options = optimset('Display','iter');
% 2) then add options parameter to fminsearch() call:
% %x = fminsearch(fun,x0,options);


% (A) finding minimum of Matlab's built-in functions
x0 = 1;
x = fminsearch(@cos,x0);


% (B) finding minima for self-defined arithmetic functions
fun = @(x)(0.1*x+cos(x));
x = [-10:0.1:10];
figure(1)
hold on
plot(x,fun(x))


% (C) find minima with different starting points [hands on]

    
% (D) finding minima for any self-defined function
% go into my_fun.m and change function or make your own
x0 = [1]; % adjust x0 to match number of variables in function
%[xmin, fval, exitflag, output] = fminsearch(@my_fun,x0,options) % "my_fun" is self-defined function in folder


% (E) gradient descent algorithm to find minimum of function
% grad_descent.m run by calling grad_descent and change x0 and alpha


%% HANDS ON (2): FIT FUNCTION TO DATA

%% (F) make some data
x = [0:9];
y = 2 * x';             % just a straight line
yn = y + 3*randn(10,1); % noisy data

% plot clean and noisy data
figure(2)
hold on
plot(x, y, 'k', x, yn, 'b')

% fit model to clean data
b1a = y'/x;
b1b = pinv(x')*y;

% task: fit model to noisy data

% task: plot regression line for noisy data model into fig(2)


%% (G) get some data
Data = ...
  [0.0000    5.8955
   0.1000    3.5639
   0.2000    2.5173
   0.3000    1.9790
   0.4000    1.8990
   0.5000    1.3938
   0.6000    1.1359
   0.7000    1.0096
   0.8000    1.0343
   0.9000    0.8435
   1.0000    0.6856
   1.1000    0.6100
   1.2000    0.5392
   1.3000    0.3946
   1.4000    0.3903
   1.5000    0.5474
   1.6000    0.3459
   1.7000    0.1370
   1.8000    0.2211
   1.9000    0.1704
   2.0000    0.2636];

x = Data(:,1);
y = Data(:,2);

% plot data
figure(3)
hold on
scatter(x,y,'k');
xlabel('time'); ylabel('money');

% fit linear function slope and intercept
xmat = [ones(length(x),1) x];
b3 = pinv(xmat)*y;
plot(x, xmat*b3)

% plot exponential function as estimator
Fbase = @(x)exp(-x);
plot(x,Fbase(x))

% Define function to be fitted: single exponential
F1 = @(p,xdata)p(1)*exp(-p(2)*xdata); 
% Define function to be fitted: double exponential
%F2 = @(p,xdata)p(1)*exp(-p(2)*xdata) + p(3)*exp(-p(4)*xdata);

F = F1; % choose function to fit parameters for

Fsumsquares = @(p)sum((F(p,x) - y).^2);
opts = optimoptions('fminunc','Algorithm','quasi-newton'); % plot minimisation: ,'PlotFcns',@optimplotfval
x0 = [1 1];         % starting values for single exp
%x0 = [1 1 1 0];    % starting values for double exp

% Use FMINUNC - Find minimum of unconstrained multivariable function
[punc,ressquared,eflag,outputu] = fminunc(Fsumsquares,x0,opts);

% plot function
figure(3)
plot(x,F(punc,x),'r')
disp(['Residual error for this fit = ', num2str(ressquared,3)]); 

% plot individual exponential functions 

