%% In this file, you will find lines of code that will be used to practice analyzing a noisy signal, and filtering the noise out. In general, you will:
% 1) LOAD THE SIGNAL, 2) ANALYZE THE FREQUENCY RESPONSE WITH A SPECTROGRAM,
% 3) DESIGN AN APPROPRIATE FILTER, 4) FILTER THE SIGNAL AND PLAY IT BACK

%%You can run a portion of the code by selecting it and pressing F9. Or,
%%copy and paste the section of code in the command window. Or, select the
%%code you want to run, right click, and choose "evaluate selection" from
%%the drop down menu.


[signal , Fs] = audioread('spiderPig_whiteNoiseHigh.wav');  % "signal" is the sample data from the wav file, and "Fs" is the sampling frequency (44100 Hz for this example)

spectrogram_analysis(signal, Fs, [20 20000], 'Spectrogram') 


cutoffFreqHz = 4000;                                  %Adjust the cutoff frequency to remove the noise
normalized_cutoffFreq = cutoffFreqHz/(Fs/2);          
order = 9;                                            %Adjust the filter order to change slope of filter cutoff (6 dB/octave per order)
[b,a]=butter(order, normalized_cutoffFreq, 'low');        % Lowpass filter your signal 
fvtool(b,a);
filteredSignal = filter(b,a,signal);
soundsc(filteredSignal,44100)

%%If you finish filtering the above signal, try filtering this signal as
%%well:

[signal , Fs] = audioread('spiderPig_whiteNoiseLow.wav');

%%If you finish filtering the above signal, look into the code for
%%spectrogram_analysis.m. Try changing the variable n_samples_window and
%%see how it changes the spectrogram. 
