function [output, max_output] = make_noise(target_rms, lower_freq, upper_freq, len_sig_samp, samp_freq)

% AAB and FG 10/18
% Function to create noise
%
% Inputs
% 
%
% Outputs
% output - sine tone
%
%e.g. ;

lower_freq_samp = round(lower_freq / samp_freq * len_sig_samp);
upper_freq_samp = round(upper_freq / samp_freq * len_sig_samp);

spect_levels = [zeros(lower_freq_samp-1,1); ones(upper_freq_samp - lower_freq_samp + 1,1); zeros(len_sig_samp - upper_freq_samp,1)];

spect_levels(spect_levels==inf) = 0; % Remove infinite values (useful is using a real spectrum as input)

phase_vals = rand(length(spect_levels),1); %generate random phase vals

noise = real(ifft(sqrt(spect_levels).*(cos(2*pi*phase_vals)+1i*sin(2*pi*phase_vals))));

noise_rms = rms(noise);
gain = target_rms / noise_rms;

output = gain .* noise;

max_output = max(output);