% Introduction to Neuroimaging, fMRI 1: Preprocessing
% This workshop demonstrates how to run a basic fMRI pipeline in Automatic Analysis
% (AA). When you run the script the following things will happen:
% 1) your current matlab path will be wiped, and AA will be added to the path.
% 2) the matlab editor will open an example task list and user script.
% 3) the example user script will run when you press F5 (change doparallel first!)
% 4) if this is your first time running AA, you will receive prompts to setup your
% defaults parameters. Follow these prompts, choosing the CBU defaults if you are at
% CBU.
% 5) Once the script completes an HTML report will be generated. If all goes well, this
% will open in a web browser for your perusal. We will also change directories to the
% output folder, where you can inspect other pipeline outputs.
%
% 2019-04-08 J Carlin MRC CBU

% CBU-specific setup - change this to the directory where you have downloaded AA
% This is the release we use:
% https://github.com/MRC-CBU/automaticanalysis/releases/tag/v5.4.0_201903b
clear; clear all;
restoredefaultpath;
addpath /imaging/local/software/AA/release-5.4.0_201903/
aa_ver5;

scriptdir = fileparts(mfilename('fullpath'));
try
    copyfile(which('aa_user_demo'),scriptdir);
catch
    fprintf('copying failed - assuming the script is already in the workshop directory\n')
end
cd(scriptdir);
edit aap_tasklist_demo.xml
edit aa_user_demo
