clear all;
HRF = spm_hrf(2/22);
HRF = HRF(1:200);
HRF = HRF/max(HRF);
D1 = diff(HRF); D1(end+1) = D1(end); D1 = D1/max(D1);
D2 = diff(D1); D2(end+1) = D2(end); D2 = -D2/max(D2);
figure; hold on; plot(HRF); plot(D1); plot(D2);
%%
cmap = colorcube(64);
figure; hold on;
for i = 1:11
    if i == 6, continue; end
    d = (HRF + (i-6)*0.1*D1);
    d = d/max(d);
    plot(d,'Color',cmap(i,:),'LineWidth',2,'DisplayName',sprintf('D1 = %d',i-6));
end
plot(HRF,'k','LineWidth',4,'DisplayName','HRF');
set(gca,'FontSize',35)
legend('show')

f = figure; hold on;
for i = 1:7
    if i == 4, continue; end
    d = (HRF + (i-4)*0.05*D2);
    d = d/max(d);
    plot(d,'Color',cmap(i,:),'LineWidth',2,'DisplayName',sprintf('D2 = %d',i-4));
end
plot(HRF,'k','LineWidth',4,'DisplayName','HRF');
set(gca,'FontSize',35)
legend('show')

