%% 0. Setup
aa_ver5

%% 1. Temporal derivatives (aamod_firstlevel_model_00001)
load('aap_parameters_aamod_firstlevel_model_00001.mat');
aap.acq_details.root = fileparts(pwd);

aap.tasklist.currenttask.settings.xBF.name = 'hrf'; % set in UMS differently!!!
movefile('stats','stats0');
aamod_firstlevel_model(aap,'doit',1);

%% 2. RPV (aamod_firstlevel_model_00001)
cd stats
Vrpv = spm_vol('RPV.nii');
Yrpv = spm_read_vols(Vrpv);

Yrpv = Yrpv<0.037;

Vrpv.fname = 'GRFT.img';
spm_write_vol(Vrpv,Yrpv);
% Display --> no violation

%% 3. Scaling (aamod_firstlevel_contrast_00001)
load('aap_parameters_aamod_firstlevel_contrasts_00001.mat')
aap.acq_details.root = fileparts(pwd);

aap.tasklist.currenttask.settings.contrasts(2).con.vector = [-2 2];
copyfile('stats','stats0');
try aamod_firstlevel_contrasts(aap,'doit',1); catch, end

con_orig = spm_read_vols(spm_vol('stats0/con_0001.nii'));
con_new = spm_read_vols(spm_vol('stats/con_0001.nii'));
con_orig(20,20,20)
con_new(20,20,20) % --> autoscaling

%% 4. F-test on moco parameters (aamod_firstlevel_contrast_00001)
load('aap_parameters_aamod_firstlevel_contrasts_00001.mat')
aap.acq_details.root = fileparts(pwd);

aap.tasklist.currenttask.settings.contrasts(2).con.vector = [zeros(6,6) eye(6)];
aap.tasklist.currenttask.settings.contrasts(2).con.type = 'F';
aap.tasklist.currenttask.settings.contrasts(2).con.name = 'Motion';
copyfile('stats','stats0');
try aamod_firstlevel_contrasts(aap,'doit',1); catch, end
% Results FWE --> justified

%% 5. Thresholding (aamod_firstlevel_threshold_00001)
load('aap_parameters_aamod_firstlevel_threshold_00001.mat')
aap.acq_details.root = fileparts(pwd);

aap.tasklist.currenttask.settings.threshold.correction = 'FWE';
aap.tasklist.currenttask.settings.threshold.p = 0.05;
aap.tasklist.currenttask.settings.overlay.transparency = 0.5;
aap.tasklist.currenttask.settings.overlay.nth_slice = 2;
aamod_firstlevel_threshold(aap,'doit',1);
% jpgs