load('FX.mat')
errorbar(c,sw,'.');
ylabel('Effect')
xlabel('Subjects')

N = numel(c); % group size
m = mean(c); % group effect

%% RFX
s = std(c); % between-subject variability

% T-stat
SEM = s/sqrt(N-1);
t = m/SEM;
p = 1-tcdf(t,N-1);
fprintf('RFX t(%d) = %2.2f, p = %1.3f\n',N-1,t,p);

%% FFX
N = N*nScan; % concatenation
s = mean(sw); % average within-subject variability 

% T-stat
SEM = s/sqrt(N-1);
t = m/SEM;
p = 1-tcdf(t,N-1);
fprintf('FFX t(%d) = %2.2f, p = %1.3f\n',N-1,t,p);

%% RFX add more subject
c0 = c;
for i = 2:6
    c = [c c0];
    N(i) = numel(c); % group size
    m = mean(c); % group effect
    s = std(c); % between-subject variability
    
    % T-stat
    SEM = s/sqrt(N(i)-1);
    t(i) = m/SEM;
    p(i) = 1-tcdf(t(i),N(i)-1);
    fprintf('RFX t(%d) = %2.2f, p = %1.3f\n',N(i)-1,t(i),p(i));
end
hold on
plot(t,'k','DisplayName','t-stat')
plot(-log10(p),'r','DisplayName','p-value')
plot([1,6],[-log10(0.05) -log10(0.05)],'DisplayName','p = 0.05')
set(gca,'XTick',1:6);
set(gca,'YTick',-log10(0.5:-0.05:0));
set(gca,'YTickLabel',0.5:-0.05:0);
ylabel('p')
xlabel('# Batches')
legend show
