clear S
DIR = '/imaging/ta02/ActionWords/LD/aamod_firstlevel_contrasts_00001';
[junk, uname] = system('whoami'); uname = uname(1:end-1);
S.outdir = ['/imaging/' uname '/Workshop/LD_ANOVArep'];

% Order: Easy_WORD (4), Easy_NONWORD (3), Hard_WORD (8), Hard_NONWORD (7)
d = dir(fullfile(DIR,'CBU*'));
for i = 1:numel(d)
    fcons = spm_select('FPListRec',fullfile(DIR,d(i).name),'con_000.\.img');   
    S.imgfiles{1}{i} = fcons([4 3 8 7],:);
end
S.contrasts{1}.name = 'Int';
S.contrasts{1}.type = 'F';
S.contrasts{1}.c = [1 -1 -1 1];

S.contrasts{2}.name = 'Int:HN-HW>EN-EW';
S.contrasts{2}.type = 'T';
S.contrasts{2}.c = [1 -1 -1 1];

S.contrasts{3}.name = 'Int:EN-EW>HN-HW';
S.contrasts{3}.type = 'T';
S.contrasts{3}.c = [-1 1 1 -1];

S.contrasts{4}.name = 'Lex';
S.contrasts{4}.type = 'F';
S.contrasts{4}.c = [1 -1 1 -1];

S.contrasts{5}.name = 'Lex:Word>NonWord';
S.contrasts{5}.type = 'T';
S.contrasts{5}.c = [1 -1 1 -1];

S.contrasts{6}.name = 'Lex:NonWord>Word';
S.contrasts{6}.type = 'T';
S.contrasts{6}.c = [-1 1 -1 1];

S.contrasts{7}.name = 'Lex_Easy:Word>NonWord';
S.contrasts{7}.type = 'T';
S.contrasts{7}.c = [1 -1 0 0];

S.contrasts{8}.name = 'Lex_Easy:NonWord>Word';
S.contrasts{8}.type = 'T';
S.contrasts{8}.c = [-1 1 0 0];

S.contrasts{9}.name = 'Lex_Hard:Word>NonWord';
S.contrasts{9}.type = 'T';
S.contrasts{9}.c = [0 0 1 -1];

S.contrasts{10}.name = 'Lex_Hard:NonWord>Word';
S.contrasts{10}.type = 'T';
S.contrasts{10}.c = [0 0 -1 1];

% contrasts   - cell array of contrast structures, with fields c
%                  (matrix), type ('F' or 'T') and name (optional)
spm('Defaults','FMRI');
batch_spm_anova(S);



