clear S
DIR = '/imaging/ta02/ActionWords/LD/aamod_firstlevel_contrasts_00001';
[junk, uname] = system('whoami'); uname = uname(1:end-1);
S.outdir = ['/imaging/' uname '/Workshop/LD_ANOVA'];

% Order: Easy_Male (4), Easy_Female (3), Hard_Male (8), Hard_Female (7)
d = dir(fullfile(DIR,'CBU*'));
males = [2 5 6 7 10 12 17]; 
females = [1 3 4 8 9 11 13 14 15 16 18 19]; 
native = [1 2 3 4 5 6 7 8 9];
learned = [10 11 12 13 14 15 16 17 18 19];
imn = 0; ifmn = 0; iml = 0; ifml = 0;
for i = 1:numel(d)
    fcons = spm_select('FPListRec',fullfile(DIR,d(i).name),'con_000.\.img');   
    if ~isempty(find(i==males,1)) && ~isempty(find(i==native,1))
        imn = imn + 1;
        S.imgfiles{1}{imn} = fcons([7],:);
    elseif ~isempty(find(i==females,1)) && ~isempty(find(i==native,1))
        ifmn = ifmn + 1;
        S.imgfiles{2}{ifmn} = fcons([7],:);
    elseif ~isempty(find(i==males,1)) && ~isempty(find(i==learned,1))
        iml = iml + 1;
        S.imgfiles{3}{iml} = fcons([7],:);
    elseif ~isempty(find(i==females,1)) && ~isempty(find(i==learned,1))
        ifml = ifml + 1;
        S.imgfiles{4}{ifml} = fcons([7],:);
    end
end

S.contrasts{1}.name = 'Language';
S.contrasts{1}.type = 'F';
S.contrasts{1}.c = [1 1 -1 -1];

S.contrasts{2}.name = 'Language:Native>Learned';
S.contrasts{2}.type = 'T';
S.contrasts{2}.c = [1 1 -1 -1];

S.contrasts{3}.name = 'Language:Learned>Native';
S.contrasts{3}.type = 'T';
S.contrasts{3}.c = [-1 -1 1 1];

S.contrasts{4}.name = 'Gender';
S.contrasts{4}.type = 'F';
S.contrasts{4}.c = [1 -1 1 -1];

S.contrasts{5}.name = 'Gender:Male>Female';
S.contrasts{5}.type = 'T';
S.contrasts{5}.c = [1 -1 1 -1];

S.contrasts{6}.name = 'Gender:Female>Male';
S.contrasts{6}.type = 'T';
S.contrasts{6}.c = [-1 1 -1 1];

S.contrasts{7}.name = 'Int';
S.contrasts{7}.type = 'F';
S.contrasts{7}.c = [1 -1 -1 1];

S.contrasts{8}.name = 'Int:LearnedFemale-LearnedMale>NativeFemale-NativeMale';
S.contrasts{8}.type = 'T';
S.contrasts{8}.c = [1 -1 -1 1];

S.contrasts{9}.name = 'Int:NativeFemale-NativeMale>LearnedFemale-LearnedMale';
S.contrasts{9}.type = 'T';
S.contrasts{9}.c = [-1 1 1 -1];

S.contrasts{10}.name = 'Gender_Native';
S.contrasts{10}.type = 'F';
S.contrasts{10}.c = [1 -1 0 0];

S.contrasts{11}.name = 'Gender_Native:Male>Female';
S.contrasts{11}.type = 'T';
S.contrasts{11}.c = [1 -1 0 0];

S.contrasts{12}.name = 'Gender_Native:Female>Male';
S.contrasts{12}.type = 'T';
S.contrasts{12}.c = [-1 1 0 0];

S.contrasts{13}.name = 'Gender_Learned';
S.contrasts{13}.type = 'F';
S.contrasts{13}.c = [0 0 1 -1];

S.contrasts{14}.name = 'Gender_Learned:Male>Female';
S.contrasts{14}.type = 'T';
S.contrasts{14}.c = [0 0 1 -1];

S.contrasts{15}.name = 'Gender_Learned:Female>Male';
S.contrasts{15}.type = 'T';
S.contrasts{15}.c = [0 0 -1 1];

% contrasts   - cell array of contrast structures, with fields c
%                  (matrix), type ('F' or 'T') and name (optional)
spm('Defaults','FMRI');
batch_spm_anova(S);



