% figures to support slides on first level GLM practical.
%
% 2017 J Carlin, MRC CBU, Cambridge, UK
%
% visualisedesign()
function visualisedesign

rundata = loadbetter('rundata');
parameters = loadbetter('parameters');

figure(99);
clf(99);

inddet = 63;
ax = subplot(3,1,1);
plot(rundata(1).data(:,inddet),'k');
ylabel('signal intensity');
box off
set(gca,'tickdir','out');

ax(2) = subplot(3,1,2);
ph = plot(rundata(1).designmatrix(:,1:2));
ylabel('indicator');
box off
set(gca,'tickdir','out');
lh = legend(ph,{'face','house'});


ax(3) = subplot(3,1,3);
cx = conv2(rundata(1).designmatrix,spm_hrf(2));
cx = cx(1:size(rundata(1).data,1),:);
ph = plot(cx(:,1:2));
box off
set(gca,'tickdir','out');
ylabel('convolved with HRF')
xlabel('time (volumes)');

set(ax,'xlim',[0 size(rundata(1).data,1)]);

printstandard('visualisedesign')

axes(ax(1));
hold(ax(1),'on');
plot(medianfilter(rundata(1).data(:,inddet),31),'r:')


% visualise HRF
figure(98);
clf(98);

tr = .1;
hrf = spm_hrf(tr);
hrf = hrf / max(hrf);
x = 0:tr:(size(hrf,1)*tr)-tr;
ph = plot(x,hrf);
xlabel('time (s)');
ylabel('response')
box off
set(gca,'tickdir','out')
xlim([0,30]);
printstandard('hrf1');

hold on;
tr = 2;
hrf = spm_hrf(tr);
hrf = hrf / max(hrf);
x = 0:tr:(size(hrf,1)*tr)-tr;
ph(2) = plot(x,hrf,'go-');

lh = legend(ph,{'full','at TR=2s'});
xlim([0,30]);
printstandard('hrf2');

convevent = conv2([ones(8,1);zeros(16,1)],hrf);
x = 0:tr:(size(convevent,1)*tr)-tr;
ph(3) = plot(x,convevent,'mo-')
delete(lh)
lh = legend(ph,{'full','at TR=2s','with 16s duration'});
xlim([0,30]);
printstandard('hrf3')

% convolved design matrix
figure(97);
clf(97);
y = 1:size(rundata(1).designmatrix,1);
subplot(1,5,1);
ph = plot(cx,y);
box off
set(gca,'tickdir','out','ydir','reverse');
ylabel('time (volumes)');
xlabel('intensity')
lh = legend(ph,parameters.conditions);
set(lh,'location','southeast');
ylim([0 size(rundata(1).designmatrix,1)]);

subplot(1,5,2:5);
imagesc(cx);
xlabel('regressors')
box off
set(gca,'tickdir','out','ycolor',[1 1 1],'ytick',[]);
cb = colorbar;
ylabel(cb,'intensity');
colormap(jet(256));
set(gca,'xtick',1:4,'xticklabel',parameters.conditions);
print('designmatrix.png','-dpng','-r300')

% trend model
figure(96);
clf(96);
data = rundata(1).data;
b = [cx rundata(1).trends] \ data;
yh = [cx rundata(1).trends] * b;
res = data - yh;
subplot(1,10,1:4);
imagesc(cx);
xlabel('regressors')
box off
set(gca,'tickdir','out');
set(gca,'xtick',1:4,'xticklabel',[],'ytick',[],'ycolor',[1 1 1]);
th(1:5) = text([0:4],zeros(1,5),[{'b ='};mat2strcell(b(1:4,inddet),'%.1f')],...
    'horizontalalignment','center','verticalalignment','bottom');
box off
subplot(1,10,5:8);
imagesc(rundata(1).trends);
xlabel('covariates')
box off
set(gca,'tickdir','out');
set(gca,'xtick',1:4,'xticklabel',[],'ytick',[],'ycolor',[1 1 1]);
th(6:9) = text([1:4],zeros(1,4),mat2strcell(b(5:8,inddet),'%.1f'),...
    'horizontalalignment','center','verticalalignment','bottom');
colormap(jet(256));
box off
set(th,'visible','off');
print('designmatrix_covs.png','-dpng','-r300')
set(th,'visible','on');
subplot(1,10,9);
imagesc(yh);
set(gca,'tickdir','out');
set(gca,'xtick',1,'xticklabel',[],'ytick',[],'ycolor',[1 1 1]);
box off
xlabel('fit')
subplot(1,10,10);
imagesc(data(:,inddet));
set(gca,'tickdir','out');
set(gca,'xtick',1,'xticklabel',[],'ytick',[],'ycolor',[1 1 1]);
box off
xlabel('data')
print('designmatrix_covs_fit.png','-dpng','-r300')

% visualise a few types of experimental design
figure(95);
clf(95);
subplot(1,8,1);
y = 1:size(rundata(1).designmatrix,1);
ylabel('time (volumes)')
ph = plot(cx,y);
set(gca,'tickdir','out','ydir','reverse');
box off;
set(gca,'tickdir','out');
ylim([0 50]);
subplot(1,8,2:4);
imagesc(cx);
set(gca,'tickdir','out');
set(gca,'xtick',1:4,'xticklabel',[],'ytick',[],'ycolor',[1 1 1]);
box off
title('block')
ylim([0 50]);
subplot(1,8,5);
randcol = randpermrep(4,floor(size(cx,1)/2));
linind = sub2ind(size(cx),1:2:size(cx,1),randcol);
xmat = zeros(size(cx));
xmat(linind) = 1;
xcon = conv2(xmat,hrf);
xcon = xcon(1:size(cx,1),:);
plot(xcon,y);
set(gca,'tickdir','out','ydir','reverse');
box off;
ylim([0 50]);
subplot(1,8,6:8);
imagesc(xcon);
set(gca,'tickdir','out');
set(gca,'xtick',1:4,'xticklabel',[],'ytick',[],'ycolor',[1 1 1]);
box off
title('rapid event (fix ISI)')
ylim([0 50]);
print('designmatrix_alts.png','-dpng','-r300')

% parametric modulator analysis
% for convenience, we just insert a sinusoidal modulation - because the trials
% aren't in temporal order the predictability of this modulation is less
% obvious.
X = convolveonsets(horzcat(rundata(1).ons{:}),[ones(1,4) ones(1,4)*2 ...
    ones(1,4)*3 ones(1,4)*4],2,272,'p',sin(linspace(0,2*pi,16))');
X = bsxfun(@rdivide,X,max(X));
figure(94);
clf(94);
subplot(1,3,1);
plot((X(:,1:4) * ones(4,1)),1:272);
set(gca,'tickdir','out','ydir','reverse');
box off
ylabel('time (volumes)');
xlabel('stimulus')
ylim([0 size(rundata(1).designmatrix,1)]);
subplot(1,3,2);
plot(X(:,5),1:272);
set(gca,'tickdir','out','ydir','reverse');
box off
xlabel('modulator')
ylim([0 size(rundata(1).designmatrix,1)]);
subplot(1,3,3);
plot(X * [ones(5,1)],1:272);
set(gca,'tickdir','out','ydir','reverse');
box off
xlabel('prediction')
ylim([0 size(rundata(1).designmatrix,1)]);
set(94,'units','centimeters','paperunits','centimeters',...
    'papersize',[6 4],'paperposition',[0 0 6 4]);
printstandard('modulator')
