% load design details _+ time courses from a few voxels for a participant. Save
% to the function directory. Requires a CBU imagers account, SPM12 and knkutils.
% Used for first level GLM practical.
%
% 2017 J Carlin, MRC CBU, Cambridge, UK
%
% loadfmridata()
function loadfmridata()

datadir = '/imaging/jc01/socialid/results_mri_group/visobjlocaliser/aamod_firstlevel_estimate_00001';
subject = 'TP';
spmfile = fullfile(datadir,subject,'SPM.mat');

SPM = load(spmfile);
SPM = SPM.SPM;

% hacky fix - files moved
for n = 1:numel(SPM.xY.VY)
    SPM.xY.VY(n).fname = strrep(SPM.xY.VY(n).fname,'yv01','jc01');
end

xind = 18:29;
nx = numel(xind);
yind = 18:29;
ny = numel(yind);
sliceind = 13;
[xcoord,ycoord,zcoord] = meshgrid(xind,yind,sliceind);

parameters.conditions = {'faces','scenes','objects','scrambled'};
ncon = numel(parameters.conditions);
parameters.dur = 8;
parameters.ncov = 4;
parameters.tr = 2;
parameters.hrf = spm_hrf(2);
for sess = 1:numel(SPM.Sess)
    rowind = SPM.Sess(sess).row;
    rundata(sess).data = spm_get_data(SPM.xY.VY(rowind),...
        [xcoord(:)'; ycoord(:)'; zcoord(:)']);
    Xmat = zeros(SPM.nscan(sess),ncon);
    rundata(sess).ons = cell(1,numel(SPM.Sess(sess).U));
    for con = 1:numel(SPM.Sess(sess).U)
        conind = strcmp(parameters.conditions,SPM.Sess(sess).U(con).name{1});
        assert(sum(conind)==1)
        rundata(sess).ons{conind} = SPM.Sess(sess).U(con).ons;
        % expand up each onset to the correct duration (8 volumes)
        onsall = bsxfun(@plus,rundata(sess).ons{conind}',0:(parameters.dur-1));
        Xmat(onsall(:),conind) = 1;
    end
    rundata(sess).trends = constructpolynomialmatrix(...
        SPM.nscan(sess),0:(parameters.ncov-1));
    rundata(sess).designmatrix = Xmat;
end

outdir = fileparts(mfilename('fullpath'));
save(fullfile(outdir,'rundata.mat'),'rundata');
save(fullfile(outdir,'parameters.mat'),'parameters')
