% first level GLM practical. We load up some real fMRI data,
% and fit it using increasingly sophisticated modeling approaches.
%
% 2017 J Carlin, MRC CBU, Cambridge, UK
% johan.carlin@mrc-cbu.cam.ac.uk

clear all
close all

% presenter settings for visibility - you probably don't need this
% set(0,'defaultaxesfontsize',16,'defaulttextfontsize',16,'defaultlinelinewidth',2)

fprintf('\nINSPECT DATA\n')
% we assume you are running from a directory where these files are available
rundata = load('rundata');
% rundata is a struct array with one entry per run, and fields for data,
% designmatrix, and trends (the scanner drift model)
rundata = rundata.rundata

parameters = load('parameters');
% parameters is a struct that keeps track of some shared settings
parameters = parameters.parameters

% first, let's plot the data from one run
figure(100);
clf(100);
subplot(1,3,1);
imagesc(rundata(1).data);
title('data');
xlabel('voxels');
ylabel('time (scans)')
subplot(1,3,2);
imagesc(rundata(1).designmatrix);
set(gca,'xtick',1:numel(parameters.conditions),...
    'xticklabel',parameters.conditions);
title('design');
xlabel('regressors');
subplot(1,3,3);
imagesc(rundata(1).trends);
xlabel('covariates');
title('trend model');

fprintf('\nNAIVE MODEL FIT\n')
% so let's start out with a really naive approach - let's just fit the task model
% directly to the data
% key function to understand: vertcat takes a bunch of data (here runs) and
% concatenates into a single long matrix
alldata = vertcat(rundata.data);
alldesign = vertcat(rundata.designmatrix);
% we will add a constant because otherwise this gets really contrived
alldesign(:,end+1) = 1;
% OLS fit
b = alldesign \ alldata;
% predicted time courses and residual errors
fitted = alldesign * b;
res = alldata - fitted;
% explained variance (squared r) for the model fit
r2 = corrpairs(alldata,fitted).^2;
% quartiles and median explained variance
quartiles_raw = prctile(r2,[25 50 75])
% find the best performing voxel
[maxr2_raw,ind] = max(r2)
% and let's visualise it
figure(200);
clf(200);
ph(1) = plot(alldata(:,ind),'.-');
hold all
ph(2) = plot(fitted(:,ind),'-','linewidth',2);
l = legend(ph,{'data','fit'});
title('best fitting voxel (raw fit)')
xlabel('time (tr)')
ylabel('image intensity')
% bit hard to see what's going on unless we restrict the axis
xlim([0 200]);

% so that works surprisingly well, but it's pretty clear that our model needs to
% be improved... Over to you!
