% Automatic analysis
% User master script example (aa version 5.*.*) - c.a. 2.5h
%
% Tibor Auer, MRC-CBSU
% 01-02-2016

clear

aa_ver5

%% DEFINE SPECIFIC PARAMETERS
%  Default recipe with model
aap = aarecipe('aap_parameters_defaults_CBSU.xml','/imaging/xy01/Workshop/Material/4_aa/fmri_takslist.xml');
aap = aas_configforSPM12(aap);

% Modify standard recipe module selection here if you'd like
aap.options.wheretoprocess = 'qsub'; % queuing system            % OPTIONS: 'localsingle'|'qsub' for aa engine, typical value 'qsub'
aap.options.email = 'xy01@mrc-cbu.cam.ac.uk';
aap.options.autoidentifyfieldmaps = 1;
aap.tasksettings.aamod_roi_extract_structural.ROIfile = '/imaging/camcan/templates/Juelich-maxprob-thr25-2mm.nii';
aap.tasksettings.aamod_realignunwarp.mfp.run = 1;                % Motion FingerPrint, typical value 0
% Set slice order for slice timing correction
aap.tasksettings.aamod_slicetiming.autodetectSO = 1;
aap.tasksettings.aamod_slicetiming.refslice = 16;                % reference slice (first acquired)
aap.tasksettings.aamod_smooth.FWHM = 5;                          % smoothing kernel size, typical value 10
aap.tasksettings.aamod_roi_extract_epi.ROIfile = '/imaging/camcan/templates/Juelich-maxprob-thr25-2mm.nii';
aap.tasksettings.aamod_firstlevel_model.xBF.name = 'hrf (with time and dispersion derivatives)';
aap.tasksettings.aamod_firstlevel_model.xBF.UNITS = 'secs';      % OPTIONS: 'scans'|'secs' for onsets and durations, typical value 'secs'
aap.tasksettings.aamod_firstlevel_model.includemovementpars = 1; % Include/exclude Moco params in/from DM, typical value 1
aap.tasksettings.aamod_firstlevel_threshold.threshold.correction = 'FWE';
aap.tasksettings.aamod_firstlevel_threshold.threshold.p = 0.05;
aap.tasksettings.aamod_secondlevel_threshold.threshold.correction = 'none';
aap.tasksettings.aamod_secondlevel_threshold.threshold.p = 0.1;
aap.tasksettings.aamod_secondlevel_threshold.threshold.extent = 1000;

%% STUDY
% Directory for analysed data
aap.acq_details.root = '/imaging/xy01/Workshop';
aap.directory_conventions.analysisid = 'aa_fMRI2';
aap.directory_conventions.subject_directory_format = 3;

% Add data
aap = aas_addsession(aap,'Loc');
aap = aas_addsubject(aap,'S1',90973,'structural',2,'functional',{7});
aap = aas_addsubject(aap,'S2',90979,'structural',2,'functional',{7});

aap = aas_addinitialstream(aap,'rois',{...
    '/imaging/xy01/Workshop/Material/4_aa/SMC_L.nii',...
    '/imaging/xy01/Workshop/Material/4_aa/SMC_R.nii',...
    '/imaging/xy01/Workshop/Material/4_aa/SSC_L.nii',...
    '/imaging/xy01/Workshop/Material/4_aa/SSC_R.nii'...
    });

% Add model
% Obtain TR from the first session
h = dicominfo(mri_finddcm(aap, 90973,7));
TR = h.RepetitionTime/1000; % in seconds

% The "soft"(-coded) way
for s = 1:numel(aap.acq_details.subjects)                % for each subject
    load(['/imaging/xy01/Workshop/Material/4_aa/condition_vol_' aas_getsubjname(aap,s) '-Loc.mat']);
    for ev = 1:numel(names)                              % for each EV
        aap = aas_addevent(aap,'aamod_firstlevel_model',aas_getsubjname(aap,s),'*',...
            names{ev},...                                % name
            onsets{ev}-aap.acq_details.numdummies*TR,... % onsets
            durations{ev});                              % durations
    end
end

aap = aas_addcontrast(aap,'aamod_firstlevel_contrasts','*','singlesession:Loc','+1xRIGHTFINGER|-1xREST','Loc_RightFinger-Rest','T');
%% DO ANALYSIS
aa_doprocessing(aap);
% aa_report(fullfile(aas_getstudypath(aap),aap.directory_conventions.analysisid));
