% Automatic analysis
% User master script example (aa version 5.*.*) - c.a. 2.5h
%
% Tibor Auer, MRC-CBSU
% 01-02-2016

clear

aa_ver5

%% DEFINE SPECIFIC PARAMETERS
%  Default recipe with model
aap = aarecipe('aap_parameters_defaults_CBSU.xml','/imaging/ta02/Workshop/Material_all/4_aa/fmri_BIDS_takslist.xml');
aap = aas_configforSPM12(aap);

% Modify standard recipe module selection here if you'd like
aap.options.wheretoprocess = 'qsub'; % queuing system            % OPTIONS: 'localsingle'|'qsub' for aa engine, typical value 'qsub'
aap.options.email = 'tibor.auer@mrc-cbu.cam.ac.uk';
aap.options.autoidentifyfieldmaps = 1;
aap.tasksettings.aamod_roi_extract_structural.ROIfile = '/imaging/camcan/templates/Juelich-maxprob-thr25-2mm.nii';
aap.tasksettings.aamod_realignunwarp.mfp.run = 1;                % Motion FingerPrint, typical value 0
% Set slice order for slice timing correction
aap.tasksettings.aamod_slicetiming.autodetectSO = 1;
aap.tasksettings.aamod_slicetiming.refslice = 16;                % reference slice (first acquired)
aap.tasksettings.aamod_smooth.FWHM = 5;                          % smoothing kernel size, typical value 10
aap.tasksettings.aamod_roi_extract_epi.ROIfile = '/imaging/camcan/templates/Juelich-maxprob-thr25-2mm.nii';
aap.tasksettings.aamod_firstlevel_model.xBF.name = 'hrf (with time and dispersion derivatives)';
aap.tasksettings.aamod_firstlevel_model.xBF.UNITS = 'secs';      % OPTIONS: 'scans'|'secs' for onsets and durations, typical value 'secs'
aap.tasksettings.aamod_firstlevel_model.includemovementpars = 1; % Include/exclude Moco params in/from DM, typical value 1
aap.tasksettings.aamod_firstlevel_threshold.threshold.correction = 'FWE';
aap.tasksettings.aamod_firstlevel_threshold.threshold.p = 0.05;
aap.tasksettings.aamod_secondlevel_threshold.threshold.correction = 'none';
aap.tasksettings.aamod_secondlevel_threshold.threshold.p = 0.1;
aap.tasksettings.aamod_secondlevel_threshold.threshold.extent = 1000;

%% STUDY
% Directory for analysed data
aap.acq_details.root = '/imaging/ta02/Workshop';
aap.directory_conventions.analysisid = 'aa_fMRI4';
aap.directory_conventions.subject_directory_format = 3;

% Add input
aap.directory_conventions.rawdatadir = '/imaging/ta02/Workshop/Material_all/4_aa/BIDS';
aap.acq_details.numdummies = 0;
aap = aas_processBIDS(aap);

aap = aas_addinitialstream(aap,'rois',{...
    '/imaging/ta02/Workshop/Material_all/4_aa/SMC_L.nii',...
    '/imaging/ta02/Workshop/Material_all/4_aa/SMC_R.nii',...
    '/imaging/ta02/Workshop/Material_all/4_aa/SSC_L.nii',...
    '/imaging/ta02/Workshop/Material_all/4_aa/SSC_R.nii'...
    });

aap = aas_addcontrast(aap,'aamod_firstlevel_contrasts','*','singlesession:Loc','+1xRIGHTFINGER|-1xREST','Loc_RightFinger-Rest','T');
%% DO ANALYSIS
aa_doprocessing(aap);
aa_report(fullfile(aas_getstudypath(aap),aap.directory_conventions.analysisid));
