% File name: MatlabBasics.m
% Yaara Erez, MRC Cognition and Brain Sciences Unit
% October 2014
% This file contains examples for Matlab basics talk, focusing on variables
% and some basic commands/functions

% Note:
% Semicolons are not used here at the end of a line only for educational
% purposes.
% When you write your script, use semicolons to avoid echo (unless you're
% interested in a specific echo).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 1 - variable

% Scalar
myVariable = 9 % with echo to the command line
myVariable = 9; % semicolon at the end suppress echo at the command line
% Look at the workspace to see the variable

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 2 - Arrays

% Simple array
firstArray = [2 8 90 46 -3 5]

% Empty array
emptyArray = []

% Series
simpleSeries = 1 : 10 % default increment is 1
seriesArray = [2 : 4 : 20]
seriesArray2 = [3 : -1 :1]

whos

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 3 - Arrays - retrieval and assingment

% Retrieval
firstArray
oneElementRetrieval = firstArray(2)
arrayRetrieval = firstArray([5 3])
    
% Assignment
firstArray(2) = 100
firstArray([4 1]) = [52 7]
firstArray([2 : 3]) = []

% Check the size/length
size(firstArray)
length(firstArray)

% Replacing elements:
firstArray([1 3]) = firstArray([3 1])

% Retrieving a non-existing element --> error
%  firstArray(20)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 4 - Special indexing

firstArray(2 : end)
firstArray(end-2:end)
firstArray(:)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 5 - Matrices

myMatrix = [5 3 7 -2; 8 9 1 4; -25 200 34 72]
matrixElementRetrieval = myMatrix(2,3)
% invalidMatrix = [2 4 6; 1 3] % error - why?
arrayRetrieval = myMatrix(1, [2 4])

% Special indexing by 'end' can be used in matrices as well
% seriesMatrixRetrieval = myMatrix([1 : end], [2 : end])

% size/length of matrices
size(myMatrix)
length(myMatrix)

% Replacing rows
myMatrix([1 2], :) = myMatrix([2 1], :)

% Deleting elements
myMatrix(:, 3) = []
size(myMatrix)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 6 - Special matrices

myZeros = zeros(2,3)
% myOnes = ones(3,2)
myRandom = rand(2,2)                         % uniform distribution
% myNormalRandom = randn(3,3)                % normal distribution

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 7 - Strings

% Create a string
shortString = 'Keep smiling'   % note the workspace

% Check the size and length of the string
size(shortString)
length(shortString)

% Concatenation
longString = [shortString 'all day'] % --> Not OK
longString = [shortString ' all day'] % overrides previous definition of longString

% Check if the strings are the same
isEqual = strcmp(shortString, longString)

% Retrieve only the second part
secondPart = longString(13:end)
% or: 
% secondStrIndx = length(shortString)+1 ; 
% secondPart = longString(secondStrIndx:end)

% Check if equal
isEqual = strcmp(secondPart, 'all day') % Why are they not equal?


