% File name: MatlabBasicsExtra.m
% Yaara Erez, MRC Cognition and Brain Sciences Unit
% November 2012
% This file contains extra examples for Matlab basics talk, focusing on variables
% and some basic commands/functions.

% Note:
% Semicolons are not used here at the end of a line only for educational
% purposes.
% When you write your script, use semicolons to avoid echo (unless you're
% interested in a specific echo).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 1 - Concatenation of arrays

firstRow = [1 2 3];
anotherRow = [4 5 6];
fullMatrix1 = [firstRow; anotherRow]
fullMatrix2 = cat(1, fullMatrix1, anotherRow)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 2 - Arithmetic operations

rowVector = [5 1 9 2] 
columnVector = [7; 2; 3; 6] % we'll see a better way to define column vector below
seriesRowVector = [1 : 10]

scalar = 5
addScalar = scalar + 7

addRowVector = rowVector + 5
add2Vectors = rowVector + addRowVector
multiply2Vectors = rowVector .* addRowVector  % note the syntax  .*, this is not an multiplication of vectors as in linear algebra

 % Mathematical operators: +, - , *, /, ^ (power)

myMatrix = [5 2 7; 45 -3 10; 6 1 8];
anotherMatrix = [1 : 3; 4 : 6; 7 : 9]
multiply2Matrices = myMatrix .* anotherMatrix % note the syntax .*, this is not multiplication of matrices as in linear algebra
%divide2Matrices = myMatrix ./ anotherMatrix

sqrt(myMatrix) % square root

matrixOf2 = ones(3,3) * 2
% antherMatrixOf2 = 2 + zeros(3,3) * 2

% random numbers between 0 and 10
rand0And10 = rand(2,3) * 10

% random numbers between 3 and 4
rand3And4 = rand(2,3) + 3

% random numbers between 5 and 21
rand5And21 = (rand(2,3) * 16) + 5;

% it is also possible to define a random distribution (by using randn) with
% a specific mean and standard deviation

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Example 3 - matrix transformations

% Transpose - 'transpose' function or the symbol '
columnVector2 = transpose(rowVector); % better way to define a column vector
transMatrix = myMatrix'

% Now we know how to create a series column vector
seriesColumnVector = [2 : 20]'

% reshaping an array
matrix2RowVector = reshape(myMatrix,1,size(myMatrix,1)*size(myMatrix,2))
matrix2ColumnVector = reshape(myMatrix,numel(myMatrix),1);

exampleMatrix = [1 2 3; 4 5 6]
matrix2Matrix = reshape(exampleMatrix, 3, 2)    % note the column-wise reshape

% sum of all elements in a matrix - 3 different ways to do that
totalSumMatrix = sum(reshape(myMatrix,1,numel(myMatrix)))
totalSumMatrix = sum(sum(myMatrix))
totalSumMatrix = sum(myMatrix(:))

% standard deviation of a vector
stdVec = std(seriesColumnVector,1) % Note the second argument of 'std' function, see 'help std' for more details
