function graphicsHandles()

load('IntracellularData.mat')

% Variables:
% signal - the signal (voltage in mV)
% time - the time vector
% Fs - sampling rate in Hz (number of samplings in 1 second)
% totalTime - total time of recording in seconds


% Plot the signal, this time get the handle for the plot
hLine = plot(time, signal)

% let's see the properties of the figure object
get(hLine,'Type')
get(hLine)
% Always use a variable to get the handle, do not use the number of the
% handle directly. Example:
% get(172.08) --> error

% Create another figure
hSecondFig = figure

% Get the properties of hSecondFig
typeFig = get(hSecondFig,'Type')
get(hSecondFig)

% Plot the signal on the new figure
hLine2 = plot(time, signal)

% Get the properties of the new plot
get(hLine2,'Type')
get(hLine2)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The hierarchy is: figure --> axes --> line

% Get the first axes (from the first plot)
hFirstAxes = get(hLine,'Parent')
get(hFirstAxes,'Type')
hCurrentAxes = gca

% Get the first figure
hFirstFig = get(hFirstAxes,'Parent')
get(hFirstFig,'Type')

% Go back to plot something on the second figure
figure(hSecondFig)
plot(signal,'r')

% Close the second figure and see what happens
close(hSecondFig)

% The handle still exists (it's a variable that we defined and we didn't delete
% it)
hSecondFig

% The object does not exist, the linkage between the handle and the object
% disappeared.
% get(hSecondFig) % --> error

% Use 'set' to see the options of the properties
set(hFirstAxes)

% Change the title of the figure window
get(hFirstFig)
set(hFirstFig,'Name','First Figure')
set(hFirstFig,'NumberTitle','off')

% Add grid to the axes
set(hFirstAxes,'XGrid','on')
set(hFirstAxes,'YGrid','on')
% Remove grid
set(hFirstAxes,'XGrid','off')
set(hFirstAxes,'YGrid','off')
% Or: grid off

% Change the color of the line
set(hLine,'Color','r')

% Change the axis of the axes object
set(hFirstAxes,'XLim',[0 10])
set(hFirstAxes,'YLim',[-100 100])
% Change them back
set(hFirstAxes,'XLim',[0 20])
set(hFirstAxes,'YLim',[-60 30])

% We can create many figures, 'remember' what is in each figure, and change
% the figures that we want

close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% What about subplot?

% Create a new figure
hSecondFig = figure;

% Subplot and plot
hSub1 = subplot(3,1,1)
get(hSecondFig,'Children')
get(hSub1,'Children')
get(hSub1,'Parent')
hPlot = plot(hSub1,time,signal)
get(hSub1,'Children')
hSub2 = subplot(3,1,3)
hPlot2 = plot(hSub2,time,signal,'m--')
get(hPlot2,'Children') 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% x-label, y-label, title  - are objects themselves
hXlabel = get(hSub1,'XLabel');
set(hXlabel,'String','time (seconds)')

hTitle = get(hSub1,'Title');
set(hTitle,'String','Intracellular Recording')

close

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Saving figures
hSecondFig = figure('Visible','off');
plot(time,signal);
set(hSecondFig,'Visible','on');
set(hSecondFig,'Visible','off');

% Save the figure - as '.fig'
fileName = 'sigPlot';
saveas(hSecondFig, fileName);
% OR: saveas(hSecondFigure, fileName,'fig')
% OR: saveas(hSecondFigure, 'sigPlot','fig')

% Save the figure - as '.jpg'
saveas(hSecondFig, fileName,'jpg');

close(hSecondFig);


