function exampleGraphics2D()

% 2 vectors
a = [11 : 16];
b = [3 7 9 8 4 2];
plot(a, b);
% e = [1 : 5];
% plot(e, b)    % Wrong - e and be should have the same size

% default x axis
plot(b);

% plotting x, f(x)
x = -50:50;
y = 2.*x.^2-5;
plot(x,y);

t = [1 : 100];
plot(t, sqrt(t))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% hold on, hold off

% Overriding previous plot
c = [12 13 15];
d = [6 4 6];
plot(a, b)
plot(c, d)

% Adding plots without overriding
plot(a, b)
hold on
plot(c, d)
plot(t,sqrt(t))
hold off
plot(a,b)

% Style (see 'help plot')
plot(a,b,'m-.o')

% Subplot
subplot(2,1,1)
plot(a,b)
subplot(2,1,2)
plot(c,d)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Histogram (hist, histc, bar)
close all
x = rand(1,50)*100;
hist(x)
n = hist(x);
bar(n);
bar(n,'hist');
hist(x,5)
n = hist(x,6)

% histogram of a matrix
% mat = rand(50,3)*100;
% hist(mat);

% histc
% edges = [0:5:100];
% n2 = histc(x, edges);
% bar(edges, n2, 'histc');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The figure window

% clear figure
clf

% figure
plot(a, b);
figure;
plot(c, d);
hold on
plot(t,sqrt(t))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% accessories
clf % clear figure
plot(a, b, 'b', c, d, 'r')
currAxis = axis;
axis([currAxis(1) currAxis(2) 0 12])
text(12.8, 9.5, 'peak', 'FontSize', 10)
grid on
legend('experiment', 'control')
title('Results')
xlabel('Question')
ylabel('Score')
