function y = sem(x)

% Computes standard error (standard deviation divided by 
%  square root of N) of a vector.
%
% by Jason Taylor (18/11/2008)
% note: should be modified to handle matrices
%

% Check that input is a vector:
if nargin~=1 
  help sem
  error('No input!')
elseif sum(size(x)>1)>1
  help sem
  error('Input must be a vector!')
end

% Compute SEM:
y = std(x)/sqrt(length(x));

return
