%
% This is a batch script to get the median of each subject's RT data,
%  plot the grand mean and standard error for the two conditions. 
% 
% (simple version)
% 
% by Jason Taylor (17/11/2008)
% + updated (jt 17/11/2008): added error bars
% + updated (jt 20/11/2011): some small cosmetic improvements
%

%% (1) Define directory, filename, subject parameters:

% Project directory (where data live):
if ispc
    projdir = '\\cbsu\data\imaging\jt03\demo\rtdata\subjects';
else
    projdir = '/imaging/jt03/demo/rtdata/subjects';
end

% Working directory: (CHANGE TO A DIR YOU ARE PERMITTED TO WRITE IN!)
%wkdir = '/imaging/jt03/demo/rtdata/subjects/ga15'; % Jason's default
%wkdir = '/imaging/<user>/jt_rt_demo/ga15'; % a suggestion
%wkdir = fullfile(projdir,'ga15'); % another suggestion
wkdir = uigetdir(projdir,'Select directory to save group results in');

% Subjects:
subjects = [1:15];


%% (2) Get each subject's mean RT:

% Initialise variable to collect median RTs:
mdrt = zeros(length(subjects),2);

% Loop over subjects:
for i = 1:length(subjects)
	
	% Get current subject label:
	subj = sprintf('s%02d',subjects(i)); 
	
	% Go to subject's directory, load data:
	cd(fullfile(projdir,subj));
	load('word_nonword.mat');

	% Put median RT for each condition into mdrt:
	mdrt(i,1) = median(D.rt(D.event==1));
	mdrt(i,2) = median(D.rt(D.event==2));

end % i subjects


%% (3) Compute grand mean, standard error:

% Compute mean (collapsing over rows):
gm = mean(mdrt,1);

% Get standard error:
se = std(mdrt)/sqrt(size(mdrt,1));

% Save it as a .mat file in working directory:
cd(wkdir)
save rtdata.mat gm se


%% (4) Plot:

% Open a figure, make background white:
fig = figure('color', [1 1 1]);

% Plot means:
bar(gm);   

% Plot and format error bars:
ebar1 = line([1 1],[gm(1) gm(1)+se(1)]);
ebar2 = line([2 2],[gm(2) gm(2)+se(2)]);
set([ebar1 ebar2], 'linewidth', 6);

% Apply title, labels, etc.:
title('Grand Mean of Median RTs');
xlabel('Stimulus Type');
ylabel('RT + SEM (ms)');
set(gca, 'xticklab', {'word', 'nonword'});

% End gracefully:
fprintf(1,'\n++ done! ++\n\n');

