%
% Introductory notes on the demo dataset.
% 
% The demo dataset contains the response time (RT) data from 15 subjects
% in a word/nonword (lexical decision) task. 
% 
% by Jason Taylor, 18/11/2008 (yep, aaaaages ago)
% + updated (jt 21/11/2011) - talk is now a matlab script!
%                           - added descriptions of files to this readme
%

% If you have access to the /imaging/ directory, you should be able to see:
'/imaging/jt03/demo/presentation'
'/imaging/jt03/demo/scripts'
'/imaging/jt03/demo/rtdata/subjects'

% Note, in Windows, that's:
'\cbsu\data\imaging\jt03\demo\presentation'
'\cbsu\data\imaging\jt03\demo\scripts'
'\cbsu\data\imaging\jt03\demo\rtdata\subjects'

% Which contain the presentation files (.pdf, .m), scripts, and subject
% directories, respectively. 

% In the presentation directory, you will find:
'talk_as_script.m'             % a matlab-executable version of the talk
                               %   (warning: not very general, very hacky, and
                               %   nearly completely lacking in comments!)
'brief_intro_to_matlab.m'      % an introduction to using matlab; workspace, 
                               %   path, data types, etc., executable
                               %   line-by-line (use <F9>)
'demo_script_cell_by_cell.m'   % script showing the evolution of the script
                               %   demo_script_simple.m (see below)
'*.png, *.jpg'                 % image files used by talk_as_script

% In the scripts directory, you will find:
'demo_readme.m'                % this file!
'demo_script_simple.m'         % simple script to plot mean & sem of RT data
'demo_script_final.m'          % more elaborate script with options, loops
'demo_extra_stuff.m'           % some other things you can try with RT data
'sem.m'                        % a function to compute standard error of mean

% NOTE: In these scripts, you must change 'wkdir' to one of your directories 
% as you will not have permission to write to mine!

% In rtdata/subjects, you'll find the directories s01, s02, ... , s15, 
% and ga15. Each subject's directory contains:
'word_nonword.mat'
% which contains a structure ('D').

% If you try, eg.:
if ispc
    cd \\cbsu\data\imaging\jt03\demo\rtdata\subjects\s01 % PC
else
    cd /imaging/jt03/demo/rtdata/subjects/s01/ % Linux
end
load word_nonword.mat
whos 
D
% ...you should see that D is now in your workspace, and it contains the 
% fields 'fname','subj', etc. To see s01's trial-by-trial data, try:

subjdata = [ D.trial D.event D.rt D.acc ]

% The variable 'subjdata' now contains 480 rows (trials) and 4 columns 
% (trial index, event type, RT, accuracy). For a more useful summary, 
% try the command 'grpstats', which gives a summary statistic ('mean') 
% for some data (subjdata(:,3), the RT data) at the levels of another 
% (subjdata(:,2), the event type):

grpstats(subjdata(:,3),subjdata(:,2),{'mean'})

% One useful bit I could have added to the script is to filter out 
% incorrect trials. So, for example:

filt = subjdata(:,4);
grpstats(subjdata(find(filt),3),subjdata((find(filt)),2),{'mean'})

% Or, on line 60 of demo_script_final.m, we could change:
rt = D.rt(D.event==conds(j));
% to:
rt = D.rt(D.event==conds(j) & D.acc==1);

% If you want to be really fancy, you can put a processing flag at the 
% top of the script, e.g.:

do_accfilt = 1;  % filter based on accuracy

% ... then put an if-else-end loop around the former line 60:
if do_accfilt
    rt = D.rt(D.event==conds(j) & D.acc==1);
else
    rt = D.rt(D.event==conds(j));
end

% Right. Have fun. Let me know if you have any questions!
% - Jason.


