% These are generally quicker and more 
% elegant if vectorized...

% Exercise - vectorize them!

%% Get even numbers 2-20 
for ind=1:10
    myevennumbers(ind)=ind*2;
end;

%% Generate 10000 random numbers between 1 & 20
for ind=1:10000
    myrand(ind)=ceil(20*rand(1));
end;

%% Find the square of the numbers from 1-10
for ind=1:10
    mysquares(ind)=ind^2;
end;

%% Multiply each element in "a" by each element in "b"
a=[1 2 3 4];
b=[1 2 1 3];
for ind=1:length(a)
    c(ind)=a(ind)*b(ind);
end;

%% Given the two dimensional matrix x, 
% subtract the mean of each row
tic
x=[1 2 3 4; 2 3 4 5; 7 6 5 4; -1 -2 -3 -4];
for row=1:size(x,1)
    rowtotal=0;
    for col=1:size(x,2)
        rowtotal=rowtotal+x(row,col);
    end;
    rowmean=rowtotal/size(x,2);
    for col=1:size(x,2)
        x(row,col)=x(row,col)-rowmean;
    end;
end;
%toc

%% Find the index of the first occurence of "chicken"
x={'picasso','rembrandt','gaugin','chicken','monet'};
for ind=1:length(x)
    if (strcmp(x{ind},'chicken'))
        break;
    end;
end;
if (ind<=length(x))
    fprintf('The first chicken is at position %d\n',ind);
else
    fprintf('Not found.\n');
end;

%% Find the first artist to get 5 points or more
clear x
x(1).name='Picasso';
x(1).quality=4;
x(2).name='Monet';
x(2).quality=5;
x(3).name='Gaugin';
x(3).quality=3;
for ind=1:length(x)
    if (x(ind).quality>=5)
        fprintf('The artist is %s\n',x(ind).name);
    end;
end;
