function G_debugging_practice2019_copy(stereo)
% DEBUGGING_PRACTICE This should be a one-line description of the function.
%
%   These few lines should be used to describe the function in more detail.
%   They will be shown if the user types "help G_debugging_practice2019".
%   E.g.
%   G_debugging_practice2019([stereo]) is an error-ridden function, for 
%   practicing debugging. If all the errors are fixed then it should 
%   display a random dot stereogram of a sphere revolving within a cylinder.
%   For more precise timing and sophisticated animation, Psychtoolbox could
%   be used.
%   
%   Inputs:
%    - stero: a boolean flag indicating whether or not to present in stereo
%             (default: true)
%
%   See also    SOMEOTHERSILLYFUNCTION.

%   Any comments after the first blank line are not shown in the help.
%   These first few lines are often used to give details of version & author.
%   E.g.
%   Created by djm 
%   $Revision: 1.0 $  $Date: 01/11/2019 $

% This is an example of a single-line comment

%{
This is an example of...
...a multi-line comment!
%}

%% This is an example of a cell
% It's a chunk of the code that you might want to highlight or execute as a
% unit. This one is empty! It might not be identified until any parsing errors are corrected.

%% The main code starts here...

% Prepare to catch the errors!
dbstop if error

%% define constants
if ~nargin, stereo=true; end

cylinder.npoints=4; % number of points, e.g. 400 % THERE MIGHT BE A PROBLEM HERE!
sphere.npoints=ceil(cylinder.npoints/2);
sphere.radius=1; % arbitrary units
cylinder.radius=1.5;
origin=[0 0 0];
disparity=0.09; % radians

%% create some random points on the surface of a sphere
sphere.theta=randn(1,sphere.npoints)*0.15*pi +pi/2; % radians (from normal distribution with clustering at equator)
sphere.phi=rand(1,sphere.npoints)*2*pi; % radians (from uniform distribution)
sphere.z=origin{3}+sphere.radius*cos(sphere.theta); % THERE MIGHT BE A PROBLEM HERE!

%% create some random points on the surface of a cyclinder
cylinder.theta=rand(1,cylinder_npoints)*2*pi; % THERE MIGHT BE A PROBLEM HERE!
cylinder.z=rand(1,cylinder.npoints)*3*sphere.radius-3*sphere.radius/2;

%% define rotation speed of each point
sphere.speed=randn(1,sphere.npoints)*0+0.5; % radians per second
cylinder.speed=randn(cylinder.npoints)*0+0.5; % THERE MIGHT BE A PROBLEM HERE!

%% prepare figure, axes, and points
% (twice as many points if stereo==1)
figure(10); clf(10); set(10,'color','w')
ax=subplot('position',[1 1 1 1]); % THERE MIGHT BE A PROBLEM HERE!
sphere.handle=scatter3(ax,...
    zeros(1,sphere.npoints*(stereo+1)),...
    zeros(1,sphere.npoints*(stereo+1)),...
    repmat(sphere.z,1,stereo+1),[],'filled');
hold on
cylinder.handle=scatter3(ax,...
    zeros(1,cylinder.npoints*(stereo+1)),...
    zeros(1,cylinder.npoints*(stereo+1)),...
    repmat(cylinder.z,1,stereo),[],'solid'); % THERE MIGHT BE TWO PROBLEMS HERE!
axis tight image off
view(0,0)

%% run the animation 
time=tic; % start a timer

% this should loop until the figure is closed
while isvalid(ax) % THERE MIGHT BE A PROBLEM HERE! (OR IS IT CAUSED BY SOMETHING BELOW?)
    
    % check how far the objects should have rotated since the last display...
    sphere.phi=sphere.phi+sphere.speed*toc(time);
    cylinder.theta=cylinder.theta-cylinder.speed*toc(time);
    time=tic; %....then reset the timer 
    
    % work out the new x and y coordinates
    sphere.x=origin(1)+sphere.radius*sin(sphere.theta).*cos(sphere.phi);
    sphere.y=origin(2)+sphere.radius*sin(sphere.theta)*sin(sphere.phi);  % THERE MIGHT BE A PROBLEM HERE!
    
    cylinder.x=origin(1)+sin(cylinder.theta)*cylinder.radius;
    cylinder.y=origin(3)+cos(cylinder.theta)*cylinder.radius;
         
    if stereo=1 % THERE MIGHT BE A PROBLEM HERE!
        
        % make new sets of x codinates for rotated objects 
        sphere.x2=3*sphere.radius+origin(1)+sphere.radius*sin(sphere.theta).*cos(sphere.phi-disparity);
        cylinder.x2=3*sphere.radius+origin(1)+sin(cylinder.theta-disparity)*cylinder.radius;
        
        % update the handle of the point clouds with duplicated cyclinder and sphere    
        sphere.handle.XData=[sphere.x sphere.x2];
        cylinder.handle.XData=[cylinder.x cylinder.x2]; % THERE MIGHT BE A PROBLEM HERE! (OR IS IT SOMETHING ABOVE?)
        
        %sphere.handle.YData=[sphere.y sphere.y];
        %cylinder.handle.YData=[cylinder.y cylinder.y];
        
    else % update the handle of the point clouds with single cyclinder and sphere       

        sphere.handle.XData=sphere.x;
        cylinder.handle.XData=cylinder.x;
        
        %sphere.handle.YData=sphere.y;
        %cylinder.handle.YData=cylinder.y;
        
    end
    
    % set the colour of the points based on perceived depth
    cylinder.handle.CData=cylinder.y-min(cylinder.y);
    cylinder.handle.CData=repmat(cylinder.handle.CData/max(cylinder.handle.CData)/2+0.25,3,stereo+1)';
    
    sphere.handle.ColourData=sphere.y-min(sphere.y); % THERE MIGHT BE A PROBLEM HERE!
    sphere.handle.CData=repmat(0.75-sphere.handle.CData/max(sphere.handle.CData)/2,3,stereo+1); % THERE MIGHT BE A PROBLEM HERE!
    
    % choose some points to hide...
    cylinder.toshow=cylinder.y<0 | ...
        ((cylinder.x-origin(1)).^2 + (cylinder.z-origin(3)).^2) > sphere.radius; % the bit of the cyclinder behind the sphere
    sphere.toshow=(sphere.y>0); % the back of the sphere
    % ...and hide them
    cylinder=hidepoints(cylinder,stereo); % THERE MIGHT BE A PROBLEM HERE! (OR IS IT SOMETHING BELOW?)
    sphere=hidepoints(sphere); % THERE MIGHT BE A PROBLEM HERE!
    
    % create title for figure
    if ~exist('tit','var') 
        switch stereo
            case true
                tit=title(sprintf('Well done! Fuse stero pair with cross-eye method\n\n'));
            otherwise
                tit=title('Well done!');
        end
    end
    drawnow

    % clear the axis handle
    clear ax % THERE MIGHT BE A PROBLEM HERE!
    
end % each iteration of loop

return

function hidepoints(obj,stereo) % THERE MIGHT BE A PROBLEM HERE!

    obj.handle.CData(~repmat(obj.toshow,1,stereo+1),:)=nan; % THERE MIGHT BE A PROBLEM HERE! (OR IS IT ABOVE?)

return
