function I_vectorization_example()

% Frequencies
f1=0.01;
f2=0.03;

% Size of square image
sz=1500;

% prepare figure
figure(10); clf; colormap jet

%% Original with Loops
tic % Start timing (only use this clock for non-time-critical applications)
clear z
for row=1:sz
    for col=1:sz
        z(row,col)=sin(row*f1+col*f2);
    end
end
fprintf('\nLoops, but no preallocation: \tElapsed time is %g seconds',toc)
% Draw figure
figure(10); clf; imagesc(z)

%% still with loops, but now preallocating z
tic % Start timing (only use this clock for non-time critical applications)
clear z
z=zeros(sz,sz);
for row=1:sz
    for col=1:sz
        z(row,col)=sin(row*f1+col*f2);
    end
end
fprintf('\nLoops, now with preallocation: \tElapsed time is %g seconds',toc)
% Draw figure
%figure(10); clf; imagesc(z)

%% Vectorize to avoid loop
tic
clear z
% Make row*f1+col*f2
[x, y]=ndgrid(1:sz);
z=sin(x*f1 + y*f2);
fprintf('\nVectorized to avoid loops: \tElapsed time is %g seconds',toc)
% Draw figure
%figure(10); clf; imagesc(z);


%% Finally, it can be faster to operate on column vectors than row vectors!
X=toeplitz(sin(linspace(0,2*pi,10000))); % make an arbitrary symmetric matrix
figure(10); subplot(121); imagesc(X); axis square % plot it
N=100; % how many times to iterate

%% sum along rows...
for n=1:N
    tic;
    sum(X,2);
    time_row(n)=toc*1000;
end
fprintf('\nSumming matrix along rows: \tMean elapsed time is %g ms',mean(time_row))

%% sum down columns...
for n=1:N
    tic;
    sum(X,1);
    time_col(n)=toc*1000;
end
fprintf('\nSumming matrix down columns: \tMean elapsed time is %g ms',mean(time_col))

%% plot
subplot(122); cla
plot(rand(1,N)-1.5,time_row,'ro')
hold on
plot(rand(1,N)+0.5,time_col,'co')
set(gca,'xtick',[-1 1],'xtickLabel',{'rows','cols'})
ylabel('time (ms)')
xlabel('Sum along...')
axis tight

%%
fprintf('\nDone.\n')
return