function vector=F_problematic_script_now_as_function(radius,vectorlength)

%% statement 1
if ~exist('radius','var') || isempty(radius)
    radius = 1;
end
circumference = 2 * pi * radius;
fprintf('\nThe circumference of a circle of radius %g is %.3f.\n', radius, circumference);

%% statement 2
tic; % matlab can tell you that it assumes this is intended as a function...

if ~exist('vectorlength','var') || isempty(vectorlength)
    vectorlength=3; %... and this is intended as a variable
end

for position=1:vectorlength
    vector(position)=randi(9,1);
end
%%% Here we could have also avoided the problem by defining the whole 
%%% vector rather than looping through elements:
%   vector=randi(9,1,vectorlength);
%%% although occasionally this might not be possible.

vector(end+1)=min(vector(1:vectorlength));
fprintf('\nThe last entry in the following vector is the smallest of the preceding %g: \n%s\n',vectorlength,mat2str(vector)) 

fprintf('\nTook %g s',toc)

return