function H_debugging_practice_fixed(MySize)
% DEBUGGING_PRACTICE This should be a one-line description of the function.
%
%   These few lines should be used to describe the function in more detail.
%   They will be shown if the user types "help debugging_practice".
%   E.g.
%   debugging_practice(MySize) is an error-ridden function, with several 
%   arbitrary steps, for practice in debugging. If all the errors are fixed
%   then it should display a simple random dot stereogram of a square-based 
%   pyramid. MySize is the number of random dots per side.
%
%   See also    SOMEOTHERSILLYFUNCTION.

%   Any comments after the first blank line are not shown in the help.
%   These first few lines are often used to give details of version & author.
%   E.g.
%   Created by djm 
%   $Revision: 1.0 $  $Date: 23/11/2011 $

% This is an example of a single-line comment

%{
This is an example of...
...a multi-line comment!
%}

%% This is an example of a cell
% It's a chunk of the code that you might want to highlight or execute as a
% unit. This one is empty!

%% The main code starts here...

% Prepare to catch the errors!
dbstop if error

% If the input variable is missing, specify a default size for the "dot"
% array
if ~exist('MySize','var')
    % mysize=300;
    MySize=300; % BE CAREFUL AND CONSITENT WITH VARIABLE NAMES!
end

% Prepare a MySize x MySize matrix, filled randomly with ones and zeros
% M=round(rand(1:MySize)); % THERE MIGHT BE TWO PROBLEMS HERE!
M=round(rand(MySize)); % RAND TAKES A SCALAR INPUT N, TO RETURN AN N-by-N MATRIX
% check this by typing >> help rand

% resample the matrix onto a 100x100 grid
% (not especially useful, but provides more opportunity for errors!)
finalsize=100;
x=repmat(linspace(1,MySize,finalsize),[finalsize,1]);
% y=repmat(linspace(1,MySize,finalsize),finalsize,2])'; % THERE MIGHT BE A PROBLEM HERE!
% CHECK THAT ALL BRACKETS ARE BALANCED, AND THAT ANY TRANSPOSES ARE IN THE RIGHT PLACE! 
y=repmat(linspace(1,MySize,finalsize)',[1,finalsize]);
M=interp2(M, x, y,'nearest'); % THERE MIGHT BE A PROBLEM HERE, if the inputs to the function are not compatible...

%% This chunk of code should generate the stereogram

% Here we'll use a simple loop to generate the lefthand and righthand images. 
% One might consider vectorizing this for efficiency.  
% However, to increase the opportinuty for errors (!) we'll make one image 
% 2D (e.g. for greyscale display) and the other 3D, with 3 layers in the 3rd
% dimension (e.g. for RGB display).
% Because the two images have different dimensions, we'll put them in a
% cell array, so we'll define this here:
I=cell(1,2);
for hemifield=1:2
    fprintf('\nPreparing image for hemifield %g',hemifield)
    
    % work out which direction to shift pixels in the two hemifields
    shift=3-hemifield*2;
    
    % make a copy of M
    temp=M;
    
    % Here's another loop for each step of the pyramid; again, it might be
    % vectorizable...
    for step=1:3:floor(finalsize)
        fprintf('.')
        
        % create a binary mask that represents the pixels we want to shift 
        % at this step of the pyramid
        % mask=zeros(size(M)); % WE WILL USE THIS MATRIX FOR LOGICAL
        % INDEXING, SO THE DATATYPE MUST BE LOGICAL RATHER THAN DOUBLE
        mask=false(size(M)); 
        mask(step:end-step,step:end-step)=1;
        % cut out this patch
        patch=temp(mask); % THERE MIGHT BE A PROBLEM HERE! (if the values of mask are valid indexes)
        % blank any pixels under the mask
        temp(mask)=nan;
        % copy the patch back at a shifted position
        temp(circshift(mask,[0 ceil(shift*step/100)]))=patch;
        % fill any gaps with random noise
        temp(isnan(temp))=round(rand(1,sum(isnan(temp(:)))));
    end
    
    % store this in our output array
    %I(hemifield)=temp; % THERE MIGHT BE A PROBLEM HERE!
    I{hemifield}=temp; % WE DEFINED I AS A CELL ARRAY, SO WE NEED TO USE CURLY BRACKETS
    
    % clear variables that we've finished with
    % clear temp step hemifield % BE CAREFUL WITH CLEAR: DONT CLEAR VARIABLES THAT ARE STILL NEEDED!
    clear temp step 
    
    % convert the second matrix to a 3-channel image, and add a Christmassy coloured tint.
    % if hemifield=2, % THERE MIGHT BE TWO PROBLEMS HERE (one caused by something above)
    if hemifield==2, % USE = TO SET A VARIABLE, BUT == AS THE LOGICAL OPERATOR
        I{hemifield}=cat(3,I{hemifield},0.7*I{hemifield}+0.6-I{hemifield},0.3*I{hemifield});
    end
    
end % next hemifield

%% This chunk of code should display the images
fprintf('\nDisplaying final figure...')

% create/find a figure
fignum=10;
figure(fignum)
% clear it
clf

% set units of screen to be normalised (i.e. ranging from 0 to 1)
% set(0,'Units','normalized') 
% THERE WAS NO NEED TO DO THIS! IF WE HAD, WE WOULD HAVE HAD TO ALSO 
% SPECIFY THE FIGURE POSITION IN NORMALIZED UNITS. NOW WE'LL SET IT BACK TO
% PIXELS IN CASE WE MESSED IT UP EARLIER
set(0,'Units','pixels') ;

% find out the size of the screen in pixels
bounds=get(0,'ScreenSize');

% resize figure to cover most of the screen
set(fignum,'position',[38 38 bounds(3:4)-120]); % THERE MIGHT BE A PROBLEM HERE! (if the position vector doesn't fit within the specified figure, given its units)

% Use a sub function to display the left matrix (this is efficient because 
% we will repeat this code for each hemifield). Provide the matrix to display, and the
% location, as inputs.

% showmatrix([0.25 0.05 0.24 0.95],I{2}); % THERE MIGHT BE A PROBLEM HERE!
% MAKE SURE THAT FUNCTION NAMES ARE CORRECT
displaymatrix([0.25 0.05 0.24 0.95],I{2});
% add a title
title({'Fuse pair with cross-eye method','to see pyramid   poke out of screen'})
% repeat for the right hand matrix
% MAKE SURE THAT ALL REQUIRED INPUTs ARE PROVIDED IN THE CORRECT ORDER
%displaymatrix(I{1},[0.51 0.05 0.24 0.95]);
displaymatrix([0.51 0.05 0.24 0.95],I{1});
title({'Fuse pair with cross-eye method','to see   pyramid poke out of screen'})

% Done?!
secretmessage=[87 101 108 108 32 100 111 110 101 33];
fprintf('\nFinished. %s \n',char(secretmessage))
return

%%
function displaymatrix(myposition, mymatrix)
% Little subfunction to display a matrix at a given position, with spcific
% formating
%
% INPUTS:
% myposition  - 4-element vector defining where to place the image
% mymatrix    - image data to display (NxM or NxMx3)
%
% Create the axes
% (the default is for these units to be normalised i.e. specified as a
% proportion of the figure window)
axes('position',myposition) % THERE MIGHT BE A PROBLEM HERE! (if myposition is not a vector of 4 numbers specifying a valid position)

% display the matrix
switch ndims(mymatrix)
    case {2, 3}
        imagesc(mymatrix);
    otherwise
        error('mymatrix should be 2D or 3D')
end

% make the aspect ratio square, and make axes invisible
axis image off

% set colourmap for 2D images
colormap prism 

drawnow

return
