% These important parameters can be easily adjusted independently of
% everything else. They're at the top for convenience.
stimuli={'AAAA','BBBB','CCCC','DDDD'};
num_reps=10;

% Calculate how many conditions, and how many trials
num_conds=length(stimuli);
num_trials=num_conds*num_reps;

% Reset random seed so that you get different trial orders every time (even
% when Matlab has just been started)
rng('shuffle'); % rand('state',sum(100*clock));

% num_reps trials of each condition, in randomized order
trialtype=kron(1:num_conds,ones(1,num_reps));
%{
In this case, a more intuative way might be:
trialtype=repmat(1:num_conds,[1 num_reps]);
Both will lead to the same result because the sequence is randomised below.
%}
trialtype=trialtype(randperm(num_trials));

fprintf('Experiment begins\n');
tic
timerun=nan(1,num_trials);

% Main trial loop
for trialind=1:num_trials
    fprintf('Trial %d, this is an example of stimulus %d... %s\n',trialind, ...
        trialtype(trialind),stimuli{trialtype(trialind)});
    timerun(trialind)=toc;
    pause(0.1);
end;