function debugging_practice_fixed(MySize)
% DEBUGGING_PRACTICE This should be a one-line description of the function.
%
%   These few lines should be used to describe the function in more detail.
%   They will be shown if the user types "help debugging_practice".
%   E.g.
%   debugging_practice(MySize) is an error-ridden function, with several 
%   arbitrary steps, for practice in debugging. If all the errors are fixed
%   then it should display a simple random dot stereogram of a square-based 
%   pyramid.
%
%   See also    SOMEOTHERFUNCTION.

%   Any comments after the first blank line are not shown in the help.
%   The first few lines are often used to give details of version & author.
%   E.g.
%   Created by djm 
%   $Revision: 1.0 $  $Date: 23/11/2011 $

% This is an example of a single-line comment

%{
This is an example of...
...a multi-line comment!
%}

%% This is an example of a cell
% It's a chunk of the code that you might want to highlight or execute as a
% unit. This one is empty!

%% The main code starts here...

% Prepare to catch the errors!
dbstop if error

% If the input variable is missing, specify a default size for the "dot"
% array
if ~exist('MySize','var')
    % mysize=100;
    MySize=100; % BE CAREFUL AND CONSITENT WITH VARIABLE NAMES!
end

% Prepare a MySize x MySize matrix, filled randomly with one and zeros
% M=round(rand(1:MySize)); % THERE MIGHT BE TWO PROBLEMS HERE!
M=round(rand(MySize)); % RAND TAKES A SCALAR INPUT N, TO RETURN AN N-by-N MATRIX

% resample the matrix onto a 100x100 grid
% (not especially useful, but provides more opportunity for errors!)
finalsize=100;
x=repmat(linspace(1,MySize,finalsize),[finalsize,1]);
% y=repmat(linspace(1,MySize,finalsize),1,finalsize]); % THERE MIGHT BE A PROBLEM HERE!
% CHECK THAT ALL BRACKETS ARE BALANCED, AND THAT ANY TRANSPOSES ARE IN THE RIGHT PLACE! 
y=repmat(linspace(1,MySize,finalsize)',[1,finalsize]);
M=interp2(M, x, y,'nearest'); % THERE MIGHT BE A PROBLEM HERE!

%% This chunk of code should generate the stereogram

% Here we'll use a simple loop to generate the lefthand and righthand images. 
% One might consider vectorizing this for efficiency.  
% However, to increase the opportinuty for errors (!) we'll make one image 
% 2D (e.g. for greyscale display) and the other 3D, with 3 layers in the 3rd
% dimension (e.g. for RGB display).
% Because the two images have different dimensions, we'll put them in a
% cell array, so we'll define this here:
I=cell(1,2);
for hemifield=1:2
    fprintf('\nPreparing image for hemifield %g',hemifield)
    
    % work out which direction to shift pixels in the two hemifields
    shift=3-hemifield*2;
    
    % make a copy of M
    temp=M;
    
    % Here's another loop for each step of the pyramid; again, it might be
    % vectorizable...
    for step=1:3:floor(finalsize)
        fprintf('.')
        
        % create a binary mask that represents the pixels we want to shift 
        % at this level
        % mask=zeros(size(M)); % WE WILL USE THIS MATRIX FOR LOGICAL
        % INDEXING, SO THE DATATYPE MUST BE LOGICAL RATHER THAN DOUBLE
        mask=false(size(M)); 
        mask(step:end-step,step:end-step)=1;
        % cut out this patch
        patch=temp(mask); % THERE MIGHT BE A PROBLEM HERE!
        % blank any pixels under the mask
        temp(mask)=nan;
        % copy the patch back at a shifted position
        temp(circshift(mask,[0 ceil(shift*step/100)]))=patch;
        % fill any gaps with random noise
        temp(isnan(temp))=round(rand(1,sum(isnan(temp(:)))));
    end
    
    % store this in our output array
    %I(hemifield)=temp; % THERE MIGHT BE A PROBLEM HERE!
    I{hemifield}=temp; % WE DEFINED I AS A CELL ARRAY, SO WE NEED TO USE CURLY BRACKETS
    
    % clear variables that we've finished with
    % clear temp step hemifield % BE CAREFUL WITH CLEAR: DONT CLEAR VARIABLES THAT ARE STILL NEEDED!
    clear temp step 
    
    % convert the second matrix to a 3-channel image, where we will add a pink tint.
    % if hemifield=2, % THERE MIGHT BE TWO PROBLEMS HERE
    if hemifield==2, % USE = TO SET A VARIABLE, BUT == AS THE LOGICAL OPERATOR
        I{hemifield}=cat(3,I{hemifield},0.5*I{hemifield},0.5*I{hemifield});
    end
    
end % next hemifield

%% This chunk of code should display the images
fprintf('\nDisplaying final figure...')

% create/find a figure
fignum=10;
figure(fignum)
% clear it
clf

% set units of screen to be normalised (i.e. ranging from 0 to 1)
% set(0,'Units','normalized') 
% THERE WAS NO NEED TO DO THIS! IF WE HAD, WE WOULD HAVE HAD TO ALSO 
% SPECIFY THE FIGURE POSITION IN NORMALIZED UNITS. NOW WE'LL SET IT BACK TO
% PIXELS IN CASE WE MESSED IT UP EARLIER
set(0,'Units','pixels') ;

% find out the size of the screen in pixels
bounds=get(0,'ScreenSize');

% resize figure to cover most of the screen
set(fignum,'position',[2 2 bounds(3:4)-35]); % THERE MIGHT BE A PROBLEM HERE!

% Use a sub function to display the left matrix (this is efficient because 
% we will repeat this code twice). Provide the matrix to display, and the
% location, as inputs.

% showmatrix(M,[0.05 0.05 0.45 0.95]); % THERE MIGHT BE TWO PROBLEMS HERE!
% MAKE SURE THAT FUNCTION NAMES ARE CORRECT, AND ALL REQUIRED INPUT ARE
% PROVIDED IN THE CORRECT ORDER
displaymatrix([0.15 0.05 0.34 0.95],I{2});
title({'Fuse pair with cross-eye method','to see pyramid   poke out of screen'})
% repeat for the right matrix
displaymatrix([0.51 0.05 0.34 0.95],I{1});
title({'Fuse pair with cross-eye method','to see   pyramid poke out of screen'})

% Done?!
fprintf('\nDone.\n')
return

%%
function displaymatrix(myposition, mymatrix)
% Little subfunction to display a matrix at a given position, with spcific
% formating

% Create the axes
% (the default is for these units to be normalised i.e. specified as a
% proportion of the figure window)
axes('position',myposition) % THERE MIGHT BE A PROBLEM HERE!

% display the matrix
switch ndims(mymatrix)
    case 2
        imagesc(mymatrix);
    case 3
        imshow(mymatrix);
    otherwise
        error('mymatrix should be 2D or 3D')
end

% make the aspect ratio square, and make axes invisible
axis image off
% make it black and white
% colormap grey % THERE MIGHT BE A PROBLEM HERE! 
colormap gray % WE'LL HAVE TO USE AMERICAN SPELLINGS

drawnow

return
