function BasicPlotFunctions()

%% Plot 2 vectors against each other
a = 11:16;
b = [3 7 9 8 4 2];
figure
plot(a, b);
% e = [1 : 5];
% plot(e, b)    % Wrong - e and be should have the same size

% default x axis
plot(b);

% Style (see 'help plot')
plot(a, b,'m-.o')

% plotting x, f(x)
x = -50:50;
y = 2.*x.^2-5;
plot(x,y);

t = 1:100;
plot(t, sqrt(t))


%% hold on, hold off

% This will override the previous plot
c = [12 13 15];
d = [6 4 6];
plot(a, b)
plot(c, d)

% Adding plots without overriding
plot(a, b)
hold on
plot(c, d)
plot(t, sqrt(t))
hold off
plot(a, b)

%% Subplot
figure
subplot(2,1,1)
plot(a, b)
subplot(2,1,2)
plot(c, d)

% Decide on your own where to put the subplots:
figure
subplot('Position',[0.1, 0.2, 0.3, 0.3])
plot(a, b)
subplot('Position',[0.5, 0.1, 0.4, 0.7])
plot(c, d)



%% Histogram (hist, histc, bar)
close all
x = rand(1,50)*100;
hist(x)
n = hist(x);
bar(n);
bar(n,'hist');
hist(x,5)
n = hist(x,6)
bar(n)

% Histogram of a matrix
mat = rand(50,3)*100;
hist(mat);
n = hist(mat);
bar(n,'stacked')

% histc
edges = 0:5:100;
n2 = histc(x, edges);
bar(edges, n2, 'histc');

%% Styles and Annotations
clf % clear figure
plot(a, b, 'r')
hold on
plot(c, d, 'g:')
text(13, 8.5, 'Peak', 'FontSize', 10)
grid on
legend('Group A', 'Group B')
title('Results')
xlabel('Question')
ylabel('Score')

%% Errorbar (and setting some figure and axis properties)
load('BehaviouralRatings.mat')
 
figure
hold on
errorbar(time,mean(Slow),std(Slow)/sqrt(length(subj)),'Color',[143 12 0]./255,'LineWidth',2)
errorbar(time,mean(Fast),std(Fast)/sqrt(length(subj)),'Color',[4 226 134]./255,'LineWidth',2)

title('Speech rate perception during decay period','FontSize',12,'FontWeight','bold')
xlabel('Time in sec','FontSize',11,'FontWeight','bold')
ylabel('Rating','FontSize',11,'FontWeight','bold')
set(gcf,'Color','w') % gcf - get handle for the current figure


set(gca,'FontSize',11,'FontWeight','bold','LineWidth',2) ; % gca = get handle for the current axis
axis([0.5 60.5 3 6])

legend('After slow','After fast')
legend('boxoff');

%% Combine bar and errorbar...
figure
bar(time,mean(Slow),'FaceColor',[143 12 0]./255);
hold on
errorbar(time,mean(Slow),std(Slow)/sqrt(length(subj)),'k','LineStyle','none')

%% And close your figures
close % close the current figure
close all

%% try help rose, pie


%% Practice
% * Generate a random vector phaseDiff with 60 values between 0 and 2*pi
% * Use four subplots (2x2) to show the data as a) plotted against the default axis, b) as a bar plot, 
%   c) as a histogram and d) as a angle histogram plot
% * Look at the axis command ('help axis') and see whether you can make
%   some of the subplots prettier