% 
% This is what I showed in the demonstration. It is meant to show
%  the evolution of demo_script_simple.m:
%
%    - First, write description of what the script will do
%    - Second, write comments describing each step
%    - Third, flesh out each step with code
%
% The 'strings' at the top of each cell are annotations.
%
% Use <ctrl>+<down> and <ctrl>+<up> to navigate between cells.
%
%   by Jason Taylor (21 Nov 2011)
%

















%%

'At top: What the script does, when created (updated)?'

% This is a batch script to get the median of each subject's RT data,
%  plot the grand mean and standard error for the two conditions. 
% 
% by Jason Taylor (17/11/2008)
% + updated (jt 17/11/2008): added error bars
%

































%%

'In body: Write an outline using comments'


% (1) Define directory, filename, subject parameters



% (2) Get each subject's median RT



% (3) Compute grand mean, standard error



% (4) Plot bar graph with error bars


































%%

'Then fill in with increasingly specific comments (as necessary) & commands'


% (1) Define directory, filename, subject parameters:

% Project directory:
if ispc
    projdir = '\\cbsu\data\imaging\jt03\demo\rtdata\subjects';
else
    projdir = '/imaging/jt03/demo/rtdata/subjects';
end

% Working directory (where summary data will be saved):
if ispc
    wkdir = '\\cbsu\data\imaging\jt03\demo\rtdata\ga15';
else
    wkdir = '/imaging/jt03/demo/rtdata/ga15';
end

% Subjects:
subjects = [1:15];


































%%

'...continue to fill in ...'


% (2) Get each subject's median RT:

% Initialise variable (subjects x conditions) to collect median RTs:
mdrt = zeros(length(subjects),2);  

% Loop over subjects:
for i = 1:length(subjects)
	
	% Get current subject label:
	subj = sprintf('s%02d',subjects(i)); 
	
	% Go to subject's directory, load data:
	cd(fullfile(projdir,subj));
	load('word_nonword.mat');

	% Put median RT for each condition into summary matrix:
	mdrt(i,1) = median(D.rt(D.event==1));
	mdrt(i,2) = median(D.rt(D.event==2));

end % i subjects































%%

'...continue to fill in ...'


% (3) Compute grand mean, standard error:

% Compute mean (collapsing over rows):
gm = mean(mdrt,1);

% Get standard error:
se = std(mdrt)/sqrt(size(mdrt,1));

% Save it as a .mat file in working directory:
cd(wkdir)
save rtdata.mat gm se


































%%

'...continue to fill in ...'


% (4) Plot:

% Open a figure, make background white:
fig = figure;
set(fig, 'color', [1 1 1])

% Plot means:
bar(gm);   

% Rescale axes:
ymax = ceil(max(gm+se));
ymin = floor(min(gm-se));
set(gca, 'ylim', [ymin ymax]);

% Plot and format error bars:
ebar1 = line([1 1],[gm(1) gm(1)+se(1)]);
ebar2 = line([2 2],[gm(2) gm(2)+se(2)]);
set([ebar1 ebar2], 'linewidth', 6);



































%% 

'...continue to fill in ...'


% Apply title, labels, etc.:
title('Grand Mean of Median RTs');
xlabel('Stimulus Type');
ylabel('RT + SEM (ms)');
set(gca, 'xticklab', {'word', 'nonword'});

% End gracefully:
fprintf(1,'\n++ done! ++\n\n');



















%% 

'To run the script, type at the Command Line (or highlight and <F9>):'

demo_script_simple


'To run a version with nicer formatting, type:'

demo_script_final


'To edit/view either of these scripts, type:'

edit('../scripts/demo_script_simple')
edit('../demo_script_final');

'If you launched this from the presenation...'
'To return to the presentation, type:'

return


























