#!/bin/sh
#PBS -v MDCE_DECODE_FUNCTION,MDCE_STORAGE_LOCATION,MDCE_STORAGE_CONSTRUCTOR,MDCE_JOB_LOCATION,MDCE_TASK_ID,MDCE_MATLAB_EXE,MDCE_MATLAB_ARGS,MDCE_SCHED_TYPE,MDCE_DEBUG,MLM_WEB_LICENSE,MLM_WEB_USER_CRED,MLM_WEB_ID
#PBS -h
#PBS -j oe
#PBS -l nodes=1


# Copyright 2006-2012 The MathWorks, Inc.

# Check that our environment is intact
if [ ${MDCE_DECODE_FUNCTION:-X} = X ] ; then
    echo "Fatal error: environment variable MDCE_DECODE_FUNCTION is not set on the cluster"
    echo "This may happen if you have used '-v' in your scheduler SubmitArguments"
    echo "Please either use another means to transmit the information, or use '-V'"
    exit 1
fi

# Put ourselves in the TMPDIR for job execution - create one if none exists.
if [ ${TMPDIR:-X} = X ] ; then
    # Create a job directory
    TMPDIR=/tmp/${PBS_JOBID?"PBS_JOBID not defined!"}
    mkdir -p ${TMPDIR}
    export TMPDIR
    echo "Created directory: ${TMPDIR} on `hostname`"
    trap "cd /tmp ; rm -rf ${TMPDIR} ; echo Removed ${TMPDIR}" 0 1 2 15
fi
cd ${TMPDIR}

echo "Executing: ${MDCE_MATLAB_EXE} ${MDCE_MATLAB_ARGS}"
 "${MDCE_MATLAB_EXE}" ${MDCE_MATLAB_ARGS}
echo "MATLAB exited with code: $?"



# This script was submitted with the following command line:
# qsub -q compute -l mem=4gb -l walltime=86400 -o "/home/ta02/aaworker/20131206T175952_tpe91be3eb_3e72_4c80_82a5_3633921b70f0/Job31/Task1.log"  -N Job31Task1 "/home/ta02/aaworker/20131206T175952_tpe91be3eb_3e72_4c80_82a5_3633921b70f0/Job31/Job31_script.sh"
