% Example script to run a TMS optimization
% Guilherme Saturnino, 2019

%add path of simNIBs matlab tools
addpath('/Users/ah08/Applications/SimNIBS-3.2/matlab/');

%change path to group data
cd('~/Desktop/COGNESTIC/2022/simnibs/simnibs_examples/ernie/');

% Initialize structure
tms_opt = opt_struct('TMSoptimize');
% Select the head mesh
tms_opt.fnamehead = 'ernie.msh';
% Select output folder
tms_opt.pathfem = '03_tms_optimization/';
% Select the coil model
tms_opt.fnamecoil = 'Magstim_70mm_Fig8.nii.gz';
% Select a target for the optimization
tms_opt.target = [-43.4, -20.7, 83.4]; %mni2subject_coords([-56, -6, 26], 'm2m_ernie');
% Optional: Use the MKL PARDISO solver
% Will make the simulations much faster
% but has large (approx 12GB) memory usage
tms_opt.solver_options = 'pardiso';

% Run optimization
run_simnibs(tms_opt);