%
% example script that runs a simple simnibs TMS simulation
% 
% G. Saturnino, A. Thielscher, 2018
%

%change directory to where data is kept
cd('~/Desktop/COGNESTIC/2022/simnibs/simnibs_examples/ernie/');

%add path of simNIBs matlab tools
addpath('/Users/ah08/Applications/SimNIBS-3.2/matlab/');

%% General information

S = sim_struct('SESSION');
S.fnamehead = 'ernie.msh'; % head mesh
S.map_to_fsavg = true;
S.map_to_MNI = true;
S.map_to_vol = true;
S.fields = 'eEjJ';
S.pathfem = '01_tms'; %Folder for the simulation output

%% Define TMS simulation
S.poslist{1} = sim_struct('TMSLIST');
S.poslist{1}.fnamecoil = 'Magstim_70mm_Fig8.nii.gz'; % Choose a coil in the ccd-files folder
S.poslist{1}.anisotropy_type = 'scalar'; %?scalar?, ?vn?, ?dir? or ?mc?; vn recommended for simulations with anisotropic conductivities (Opitz et al., 2011) 

%Define Position
S.poslist{1}.pos(1).centre = 'C3'; % Place it over C3
S.poslist{1}.pos(1).pos_ydir = 'CP3'; % Polongation of coil handle (see documentation)
S.poslist{1}.pos(1).distance = 4; % 4 mm distance from coil surface to head surface
S.poslist{1}.pos(1).didt = 5e6; % 1e6 is default Rate of change of current in the coil, in A/s. Sometimes provided on screen after a pulse is given.

S.poslist{2} = sim_struct('TMSLIST');
S.poslist{2}.fnamecoil = 'Magstim_70mm_Fig8.nii.gz'; % Choose a coil in the ccd-files folder
S.poslist{2}.anisotropy_type = 'scalar';
S.poslist{2}.pos(1).distance = 4;
S.poslist{2}.pos(1).didt = 5e6;
S.poslist{2}.pos(1).matsimnibs = [...
 -1  0  0 -1.2;...
  0  1  0 -15.8;...
  0  0 -1 120.0;...
  0  0  0 1]; % manually set x y z position (first three rows) (+y is anterior direction, +z is superior (so always negative is facing down, and x = y*z to be right handed)


%% Run Simulation
run_simnibs(S);

%% Visualize Simulations
m = mesh_load_gmsh4(fullfile(S.pathfem, 'ernie_TMS_2-0001_Magstim_70mm_Fig8_nii_scalar.msh'));
mesh_show_surface(m);
