%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% T.Auer, 2/7/13; tibor.auer@mrc-cbu.cam.ac.uk
%
% spm_SVC
% A customised verions of spm_VOI* to fit for scripting
%
% *Copyright (C) 1999-2013 Wellcome Trust Centre for Neuroimaging
%  Karl Friston
%  $Id: spm_VOI.m 5191 2013-01-17 18:41:14Z guillaume $
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function TabDat = spm_SVC(SPM,xSPM,hReg,SPACE,xyzmm,D)

Num      = spm_get_defaults('stats.results.svc.nbmax');   % maxima per cluster
Dis      = spm_get_defaults('stats.results.svc.distmin'); % distance among maxima {mm}

%-Title
%--------------------------------------------------------------------------
spm('FigName',['SPM{',xSPM.STAT,'}: Small Volume Correction']);

% voxels in entire search volume {mm}
%--------------------------------------------------------------------------
XYZmm    = SPM.xVol.M(1:3,:)*[SPM.xVol.XYZ; ones(1, SPM.xVol.S)];
Q        = ones(1,size(xSPM.XYZmm,2));
O        = ones(1,size(     XYZmm,2));
FWHM     = xSPM.FWHM;


switch SPACE

    case 'S' %-Sphere
    %----------------------------------------------------------------------
    str        = sprintf('%0.1fmm sphere',D);
    j          = find(sum((xSPM.XYZmm - xyzmm*Q).^2) <= D^2);
    k          = find(sum((     XYZmm - xyzmm*O).^2) <= D^2);
    D          = D./xSPM.VOX;


    case 'B' %-Box
    %----------------------------------------------------------------------
    if length(D)~=3, D = ones(1,3)*D(1); end
    str        = sprintf('%0.1f x %0.1f x %0.1f mm box',D(1),D(2),D(3));
    j          = find(all(abs(xSPM.XYZmm - xyzmm*Q) <= D(:)*Q/2));
    k          = find(all(abs(     XYZmm - xyzmm*O) <= D(:)*O/2));
    D          = D./xSPM.VOX;

    case 'I' %-Mask Image
    %----------------------------------------------------------------------
    Msk   = xyzmm;
    D     = spm_vol(Msk);
    str   = spm_str_manip(Msk,'a30x');
    str   = sprintf('image mask: %s',str); 
    VOX   = sqrt(sum(D.mat(1:3,1:3).^2));
    FWHM  = FWHM.*(xSPM.VOX./VOX);
    XYZ   = D.mat \ [xSPM.XYZmm; ones(1, size(xSPM.XYZmm, 2))];
    j     = find(spm_sample_vol(D, XYZ(1,:), XYZ(2,:), XYZ(3,:),0) > 0);
    XYZ   = D.mat \ [     XYZmm; ones(1, size(    XYZmm, 2))];
    k     = find(spm_sample_vol(D, XYZ(1,:), XYZ(2,:), XYZ(3,:),0) > 0);
    
end

xSPM.S     = length(k);
xSPM.R     = spm_resels(FWHM,D,SPACE);
xSPM.Z     = xSPM.Z(j);
xSPM.XYZ   = xSPM.XYZ(:,j);
xSPM.XYZmm = xSPM.XYZmm(:,j);

%-Restrict FDR to the search volume
%--------------------------------------------------------------------------
df         = xSPM.df;
STAT       = xSPM.STAT;
DIM        = xSPM.DIM;
R          = xSPM.R;
n          = xSPM.n;
Vspm       = xSPM.Vspm;
u          = xSPM.u;
S          = xSPM.S;

try, xSPM.Ps  = xSPM.Ps(k); end
if STAT ~= 'P'
    [up, xSPM.Pp] = spm_uc_peakFDR(0.05,df,STAT,R,n,Vspm,k,u);
    uu            = spm_uc(0.05,df,STAT,R,n,S);
end
try % if STAT == 'T'
    V2R               = 1/prod(xSPM.FWHM(DIM>1));
    [uc, xSPM.Pc, ue] = spm_uc_clusterFDR(0.05,df,STAT,R,n,Vspm,k,V2R,u);
catch
    uc                = NaN;
    ue                = NaN;
    xSPM.Pc           = [];
end
try, xSPM.uc          = [uu up ue uc]; end

%-Tabulate p values
%--------------------------------------------------------------------------
str       = sprintf('search volume: %s',str);
if any(strcmp(SPACE,{'S','B'}))
    str = sprintf('%s at [%.0f,%.0f,%.0f]',str,xyzmm(1),xyzmm(2),xyzmm(3));
end

TabDat    = spm_list('List',xSPM,hReg,Num,Dis,str);

%-Reset title
%--------------------------------------------------------------------------
spm('FigName',['SPM{',xSPM.STAT,'}: Results']);
