Imports System
Imports System.Net
Imports System.Net.Sockets
Imports System.Threading
Imports System.Text
Imports System.io


' State object for callbacks

Public Class StateObject
    Public outSocket As Socket = Nothing
    Public inSocket As TcpListener = Nothing
End Class 'StateObject


Public Class CBURTcommunications
    ' Connection details
    Public Const portin As Integer = 6001
    Public Const portout As Integer = 6002
    Public Const realtimeip As String = "172.31.25.1"

    ' Used for incoming connections
    Public Shared networkstream As NetworkStream
    Public Shared tcpClient As TcpClient
    Public Shared clientdata As String

    ' These signal completion of various stages.
    Private Shared sendDone As New ManualResetEvent(False)
    Private Shared listeningDone As New ManualResetEvent(False)
    Private Shared helloDone As New ManualResetEvent(False)

    ' Socket object
    Private Shared client As Socket
    Private Shared listensocket As TcpListener

    ' Incoming parameters
    Public Const MAXPARMS = 256
    Public Shared Parameters(MAXPARMS)

    Private Shared myOwningForm As Form1

    Public Function GetParameter(ByVal intParmNumber As Integer)
        Return (Parameters(intParmNumber))
    End Function
    Public Sub Handshake()

        ' Send test data to the remote device.
        listeningDone.Reset()
        Send(client, "HELLO_REALTIME " + Dns.GetHostName() + Chr(13) + Chr(10))
        sendDone.WaitOne()
        helloDone.WaitOne()

    End Sub 'Main

    Public Sub SendParameter(ByVal strParmName As String, ByVal strParmValue As String)

        ' Send test data to the remote device.
        Send(client, "PARAMETER " + strParmName + " " + strParmValue + Chr(13) + Chr(10))

    End Sub 'Main
    ' Callback for asynchronous receiving
    ' Accepts incoming connections and processes the data
    Public Shared Sub AcceptTcp(ByVal ar As IAsyncResult)
        Dim listeningsocket As TcpListener = CType(ar.AsyncState, TcpListener)
        tcpClient = listeningsocket.EndAcceptTcpClient(ar)
        networkstream = tcpClient.GetStream()
        Dim bytes(tcpClient.ReceiveBufferSize) As Byte
        networkstream.Read(bytes, 0, CInt(tcpClient.ReceiveBufferSize))
        clientdata = Encoding.ASCII.GetString(bytes)
        clientdata = Left(clientdata, clientdata.IndexOf(Chr(10)))
        listeningDone.Set()
        tcpClient.Close()
        listeningsocket.Stop()
        listeningsocket.Start()
        listeningsocket.BeginAcceptTcpClient(New AsyncCallback(AddressOf AcceptTcp), listeningsocket)

        Dim fields() As String = clientdata.Split(" ")
        Select Case (fields(0))
            Case "HELLO_STIM"
                helloDone.Set()
            Case "PARAMETER"
                Dim parmnum As Integer = CInt(fields(1))
                Parameters(parmnum) = fields(2)

                Dim objWrite As New StreamWriter("c:\temp\parm" & parmnum & ".txt", False)
                objWrite.WriteLine(fields(2))
                objWrite.Close()
        End Select

    End Sub

    ' Starts a string sending asynchronously to the outgoing socket
    Private Shared Sub Send(ByVal client As Socket, ByVal data As String)
        sendDone.Reset()
        Dim byteData As Byte() = Encoding.ASCII.GetBytes(data)
        client.BeginSend(byteData, 0, byteData.Length, 0, New AsyncCallback(AddressOf SendCallback), client)
        myOwningForm.Label2.Text = ">" & data
    End Sub 'Send

    ' Callback for asynchronous sending
    Private Shared Sub SendCallback(ByVal ar As IAsyncResult)
        Dim client As Socket = CType(ar.AsyncState, Socket)
        Dim bytesSent As Integer = client.EndSend(ar)
        sendDone.Set()
    End Sub 'SendCallback

    Public Sub New()
        ' Socket for incoming connections
        listensocket = New TcpListener(portin)
        Dim state2 As New StateObject
        state2.inSocket = listensocket
        listensocket.Start()
        listensocket.BeginAcceptTcpClient(New AsyncCallback(AddressOf AcceptTcp), listensocket)

        ' Socket for outgoing information
        Dim ipHostInfo As IPHostEntry = Dns.Resolve(realtimeip)
        Dim ipAddress As IPAddress = ipHostInfo.AddressList(0)
        Dim remoteEP As New IPEndPoint(ipAddress, portout)
        client = New Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp)
        Try
            client.Connect(remoteEP)
        Catch
            MsgBox("Could not make connection to real time machine. Is it running, and is watchport_stim.py running?")
            Throw
        End Try
    End Sub

    Public Sub New(ByVal owningForm As Form)
        Me.New()
        myOwningForm = owningForm
    End Sub

    Protected Overrides Sub Finalize()
        MyBase.Finalize()
    End Sub


End Class 'AsynchronousClient

